/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions;

import com.google.inject.Inject;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.elian.ezauctions.controller.AuctionController;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.model.Auction;
import me.elian.ezauctions.model.AuctionData;
import me.elian.ezauctions.model.Bid;
import me.elian.ezauctions.model.BidList;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EzAuctionsPlaceholderExpansion
extends PlaceholderExpansion {
    private final Plugin plugin;
    private final AuctionController auctionController;
    private final ConfigController configController;
    private final Economy economy;

    @Inject
    public EzAuctionsPlaceholderExpansion(Plugin plugin, AuctionController auctionController, ConfigController configController, Economy economy) {
        this.plugin = plugin;
        this.auctionController = auctionController;
        this.configController = configController;
        this.economy = economy;
    }

    @NotNull
    public String getIdentifier() {
        return this.plugin.getName();
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)" -> ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        Bid highestBid;
        Auction auction = this.auctionController.getActiveAuction();
        if (auction == null) {
            return "";
        }
        AuctionData data = auction.getAuctionData();
        String auctioneerName = data.getAuctioneer().getOfflinePlayer().getName();
        if (auctioneerName == null) {
            auctioneerName = "";
        }
        double highestBidAmount = data.getStartingPrice();
        String highestBidderName = null;
        String highestBidderUniqueId = "";
        BidList bidList = auction.getBidList();
        if (bidList != null && (highestBid = bidList.getHighestBid()) != null && !data.isSealed()) {
            highestBidAmount = highestBid.amount();
            highestBidderName = highestBid.auctionPlayer().getOfflinePlayer().getName();
            highestBidderUniqueId = highestBid.auctionPlayer().getUniqueId().toString();
        }
        if (highestBidderName == null) {
            highestBidderName = "";
        }
        String placeholder = params.toLowerCase();
        return this.getAuctionPlaceholderValue(placeholder, data, auctioneerName, highestBidderName, highestBidAmount, highestBidderUniqueId, auction.getRemainingSeconds());
    }

    private String getAuctionPlaceholderValue(String placeholder, AuctionData data, String auctioneerName, String highestBidderName, double highestBidAmount, String highestBidderUniqueId, int remainingSeconds) {
        ItemStack item = data.getItem();
        return switch (placeholder) {
            case "auctioneer" -> auctioneerName;
            case "auctioneeruuid" -> data.getAuctioneer().getUniqueId().toString();
            case "itemamount" -> Integer.toString(data.getAmount());
            case "minecraftname" -> data.getMinecraftName();
            case "customname" -> data.getCustomName();
            case "materialtype" -> item.getType().toString().toLowerCase();
            case "startingprice" -> Double.toString(data.getStartingPrice());
            case "highestbidamount" -> Double.toString(highestBidAmount);
            case "highestbidder" -> highestBidderName;
            case "highestbidderuuid" -> highestBidderUniqueId;
            case "increment" -> Double.toString(data.getIncrementPrice());
            case "starttime" -> Integer.toString(data.getStartingAuctionTime());
            case "remainingtime" -> Integer.toString(remainingSeconds);
            case "autobuy" -> Double.toString(data.getAutoBuyPrice());
            case "world" -> data.getWorld();
            case "skullowner" -> data.getSkullOwner();
            case "repairprice" -> Integer.toString(data.getRepairPrice());
            case "antisnipetime" -> Integer.toString(this.configController.getConfig().getInt("antisnipe.time"));
            case "currencynameplural" -> this.economy.currencyNamePlural();
            case "currencynamesingular" -> this.economy.currencyNameSingular();
            default -> null;
        };
    }
}

