/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.command;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.acf.BaseCommand;
import me.elian.ezauctions.acf.RegisteredCommand;
import me.elian.ezauctions.acf.annotation.CommandAlias;
import me.elian.ezauctions.acf.annotation.CommandCompletion;
import me.elian.ezauctions.acf.annotation.CommandPermission;
import me.elian.ezauctions.acf.annotation.Default;
import me.elian.ezauctions.acf.annotation.Description;
import me.elian.ezauctions.acf.annotation.HelpCommand;
import me.elian.ezauctions.acf.annotation.Subcommand;
import me.elian.ezauctions.acf.annotation.Syntax;
import me.elian.ezauctions.controller.AuctionController;
import me.elian.ezauctions.controller.AuctionPlayerController;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.controller.ScoreboardController;
import me.elian.ezauctions.controller.UpdateController;
import me.elian.ezauctions.data.Database;
import me.elian.ezauctions.event.AuctionCancelEvent;
import me.elian.ezauctions.event.AuctionImpoundEvent;
import me.elian.ezauctions.event.AuctionQueueEvent;
import me.elian.ezauctions.helper.ItemHelper;
import me.elian.ezauctions.model.Auction;
import me.elian.ezauctions.model.AuctionData;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.AuctionPlayerIgnore;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

@Singleton
@CommandAlias(value="auction|auctions|auc|ezauctions")
@CommandPermission(value="ezauctions.auction")
@Description(value="Auction Command")
public class AuctionCommand
extends BaseCommand {
    private static final Pattern QUEUE_LIMIT_PERM_PATTERN = Pattern.compile("ezauctions\\.auction\\.queuelimit\\.([0-9]+)");
    private static final Pattern CURRENT_LIMIT_PERM_PATTERN = Pattern.compile("ezauctions\\.auction\\.currentlimit\\.([0-9]+)");
    private final Plugin plugin;
    private final Logger logger;
    private final Economy economy;
    private final AuctionController auctionController;
    private final AuctionPlayerController playerController;
    private final ConfigController config;
    private final MessageController messages;
    private final ScoreboardController scoreboard;
    private final UpdateController updateController;
    private final Database database;
    private final TaskScheduler scheduler;

    @Inject
    public AuctionCommand(Plugin plugin, Logger logger, Economy economy, AuctionController auctionController, AuctionPlayerController playerController, ConfigController config, MessageController messages, ScoreboardController scoreboard, UpdateController updateController, Database database, TaskScheduler scheduler) {
        this.plugin = plugin;
        this.logger = logger;
        this.economy = economy;
        this.auctionController = auctionController;
        this.playerController = playerController;
        this.config = config;
        this.messages = messages;
        this.scoreboard = scoreboard;
        this.updateController = updateController;
        this.database = database;
        this.scheduler = scheduler;
    }

    private static int getPermissionLimit(Player player, Pattern pattern) {
        int maxLimit = 0;
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            int limit;
            Matcher matcher = pattern.matcher(permission.getPermission());
            if (!matcher.find() || (limit = Integer.parseInt(matcher.group(1))) <= maxLimit) continue;
            maxLimit = limit;
        }
        return maxLimit;
    }

    @HelpCommand
    public void help(CommandSender sender) {
        List<RegisteredCommand> subs = this.getRegisteredCommands();
        List<String> display = new ArrayList<String>();
        for (RegisteredCommand sub : subs) {
            String subCommand;
            String[] split;
            Set<String> set = sub.getRequiredPermissions();
            if (set.stream().anyMatch(s2 -> !sender.hasPermission((String)s2)) || (split = sub.getCommand().split(" ")).length == 1 || display.contains(subCommand = split[1])) continue;
            display.add(subCommand);
        }
        if (sender.hasPermission("ezauctions.bid")) {
            display.add("bid");
        }
        this.messages.sendMessage(sender, "command.help", new TagResolver[0]);
        display = this.getCommandOrder(display);
        for (String command : display) {
            if (command.equals("bid")) {
                this.messages.sendMessage(sender, "command.bid.help", new TagResolver[0]);
                continue;
            }
            String message = "command.auction." + command + ".help";
            this.messages.sendMessage(sender, message, new TagResolver[0]);
        }
    }

    private List<String> getCommandOrder(List<String> allowedCommands) {
        ConfigurationSection helpSection = this.config.getConfig().getConfigurationSection("help");
        if (helpSection == null) {
            allowedCommands.remove("bid");
            Collections.sort(allowedCommands);
            allowedCommands.add("bid");
            return allowedCommands;
        }
        List ordered = helpSection.getStringList("order");
        ordered.removeIf(command -> !allowedCommands.contains(command));
        return ordered;
    }

    @Subcommand(value="cancel|c")
    @CommandPermission(value="ezauctions.auction.cancel")
    public void cancel(CommandSender sender) {
        this.scheduler.runAsyncTask(() -> {
            Auction current = this.auctionController.getActiveAuction();
            if (current == null) {
                this.messages.sendMessage(sender, "command.no_current_auction", new TagResolver[0]);
                return;
            }
            boolean returnMoney = true;
            if (!sender.hasPermission("ezauctions.auction.cancel.others")) {
                Player player;
                if (!(sender instanceof Player) || !(player = (Player)sender).getUniqueId().equals(current.getAuctionData().getAuctioneer().getUniqueId())) {
                    this.messages.sendMessage(sender, "command.auction.cancel.not_yours", new TagResolver[0]);
                    return;
                }
                try {
                    AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                    if (!auctionPlayer.withinBoundary(this.config)) {
                        this.messages.sendMessage((CommandSender)player, "command.auction.cancel.outside_boundary", new TagResolver[0]);
                        return;
                    }
                }
                catch (InterruptedException | ExecutionException auctionPlayer) {
                    // empty catch block
                }
                int minTime = this.config.getConfig().getInt("general.minimum-cancel-time");
                if (current.getRemainingSeconds() < minTime) {
                    this.messages.sendMessage(sender, "command.auction.cancel.too_late", new TagResolver[0]);
                    return;
                }
                returnMoney = false;
            }
            AuctionCancelEvent event = new AuctionCancelEvent(current, sender);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            boolean returnFinal = returnMoney;
            this.scheduler.runAsyncTask(() -> current.cancelAuction(returnFinal));
        });
    }

    @Subcommand(value="disable")
    @CommandPermission(value="ezauctions.auction.disable")
    public void disable(CommandSender sender) {
        String prop;
        boolean enabled = this.auctionController.isAuctionsEnabled();
        if (enabled) {
            prop = "command.auction.disable.success";
            this.auctionController.setAuctionsEnabled(false);
        } else {
            prop = "command.auction.disable.already_disabled";
        }
        this.messages.sendMessage(sender, prop, new TagResolver[0]);
    }

    @Subcommand(value="enable")
    @CommandPermission(value="ezauctions.auction.enable")
    public void enable(CommandSender sender) {
        String prop;
        boolean enabled = this.auctionController.isAuctionsEnabled();
        if (enabled) {
            prop = "command.auction.enable.already_enabled";
        } else {
            prop = "command.auction.enable.success";
            this.auctionController.setAuctionsEnabled(true);
        }
        this.messages.sendMessage(sender, prop, new TagResolver[0]);
    }

    @Subcommand(value="ignoreplayer|ignorep")
    @CommandPermission(value="ezauctions.auction.ignore.player")
    @CommandCompletion(value="@players")
    @Syntax(value="[player]")
    public void ignorePlayer(Player player, String targetName) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            if (!target.hasPlayedBefore() && !target.isOnline()) {
                this.messages.sendMessage((CommandSender)player, "command.auction.ignoreplayer.not_found", new TagResolver[0]);
                return;
            }
            if (player.getUniqueId() == target.getUniqueId()) {
                this.messages.sendMessage((CommandSender)player, "command.auction.ignoreplayer.cannot_ignore_self", new TagResolver[0]);
                return;
            }
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                Optional<AuctionPlayerIgnore> ignore = auctionPlayer.getIgnoredPlayers().stream().filter(ip -> ip.getIgnored().equals(target.getUniqueId())).findFirst();
                String targetNameActual = target.getName();
                if (targetNameActual == null) {
                    targetNameActual = targetName;
                }
                if (ignore.isPresent()) {
                    this.messages.sendMessage((CommandSender)player, "command.auction.ignoreplayer.not_ignoring", Placeholder.unparsed("ignoredplayer", targetNameActual));
                    auctionPlayer.getIgnoredPlayers().remove(ignore.get());
                } else {
                    this.messages.sendMessage((CommandSender)player, "command.auction.ignoreplayer.is_ignoring", Placeholder.unparsed("ignoredplayer", targetNameActual));
                    auctionPlayer.getIgnoredPlayers().add(new AuctionPlayerIgnore(auctionPlayer, target.getUniqueId()));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    @Subcommand(value="ignore")
    @CommandPermission(value="ezauctions.auction.ignore")
    public void ignore(Player player) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                boolean ignoringAll = auctionPlayer.isIgnoringAll();
                String prop = "command.auction.ignore." + (ignoringAll ? "disabled" : "enabled");
                this.messages.sendMessage((CommandSender)player, prop, new TagResolver[0]);
                auctionPlayer.setIgnoringAll(!ignoringAll);
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    @Subcommand(value="impound")
    @CommandPermission(value="ezauctions.auction.impound")
    public void impound(Player player) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                Auction current = this.auctionController.getActiveAuction();
                if (current == null) {
                    this.messages.sendMessage((CommandSender)player, "command.no_current_auction", new TagResolver[0]);
                    return;
                }
                AuctionImpoundEvent event = new AuctionImpoundEvent(current, player);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.messages.sendMessage((CommandSender)player, "command.auction.impound", new TagResolver[0]);
                current.impoundAuction(auctionPlayer);
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    @Subcommand(value="info|i")
    @CommandPermission(value="ezauctions.auction.info")
    public void info(CommandSender sender) {
        Auction activeAuction = this.auctionController.getActiveAuction();
        if (activeAuction == null) {
            this.messages.sendMessage(sender, "command.no_current_auction", new TagResolver[0]);
            return;
        }
        this.messages.sendAuctionMessage(sender, "auction.info", activeAuction, new TagResolver[0]);
    }

    @Subcommand(value="queue|q")
    @CommandPermission(value="ezauctions.auction.queue")
    public void queue(CommandSender sender) {
        Collection<AuctionData> queue = this.auctionController.getAuctionQueue();
        if (queue.size() == 0) {
            this.messages.sendMessage(sender, "command.auction.queue.empty", new TagResolver[0]);
            return;
        }
        this.messages.sendMessage(sender, "command.auction.queue.list", new TagResolver[0]);
        int position = 1;
        for (AuctionData data : queue) {
            this.messages.sendAuctionMessage(sender, "command.auction.queue.item", data, Formatter.number("position", position++));
        }
    }

    @Subcommand(value="remove|r")
    @CommandPermission(value="ezauctions.auction.remove")
    public void remove(Player player) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> this.auctionController.withSync(() -> {
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                AuctionData queued = this.auctionController.removeFirstItemFromQueue(auctionPlayer);
                if (queued == null) {
                    this.messages.sendMessage((CommandSender)player, "command.auction.remove.not_in_queue", new TagResolver[0]);
                    return;
                }
                this.messages.sendMessage((CommandSender)player, "command.auction.remove.success", new TagResolver[0]);
                queued.giveItemToPlayer(auctionPlayer, this.playerController, this.scheduler, this.config, this.messages);
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        }));
    }

    @Subcommand(value="scoreboard|sb")
    @CommandPermission(value="ezauctions.auction.scoreboard")
    public void scoreboard(Player player) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                boolean ignoringScoreboard = auctionPlayer.isIgnoringScoreboard();
                String prop = "command.auction.scoreboard." + (ignoringScoreboard ? "disabled" : "enabled");
                auctionPlayer.setIgnoringScoreboard(!ignoringScoreboard);
                if (auctionPlayer.isIgnoringScoreboard()) {
                    this.scoreboard.removePlayer(player);
                } else {
                    this.scoreboard.addPlayer(player);
                }
                this.messages.sendMessage((CommandSender)player, prop, new TagResolver[0]);
                this.playerController.savePlayer(auctionPlayer);
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    @Subcommand(value="spam")
    @CommandPermission(value="ezauctions.auction.spam")
    public void spam(Player player) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                boolean ignoringSpammy = auctionPlayer.isIgnoringSpammy();
                String prop = "command.auction.spam." + (ignoringSpammy ? "disabled" : "enabled");
                this.messages.sendMessage((CommandSender)player, prop, new TagResolver[0]);
                auctionPlayer.setIgnoringSpammy(!ignoringSpammy);
                this.playerController.savePlayer(auctionPlayer);
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    @Subcommand(value="end")
    @CommandPermission(value="ezauctions.auction.end")
    public void end(CommandSender sender) {
        this.scheduler.runAsyncTask(() -> this.auctionController.withSync(() -> {
            Player p;
            Auction activeAuction = this.auctionController.getActiveAuction();
            if (activeAuction == null || activeAuction.isCompleted()) {
                this.messages.sendMessage(sender, "command.no_current_auction", new TagResolver[0]);
                return;
            }
            if (sender instanceof Player && !(p = (Player)sender).hasPermission("ezauctions.auction.end.others") && !p.getUniqueId().equals(activeAuction.getAuctionData().getAuctioneer().getUniqueId())) {
                this.messages.sendMessage(sender, "command.auction.end.attempt-others", new TagResolver[0]);
                return;
            }
            this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), activeAuction, false, "auction.end", Placeholder.unparsed("endingplayer", sender.getName()));
            activeAuction.end();
        }));
    }

    @Subcommand(value="start|s")
    @CommandPermission(value="ezauctions.auction.start")
    @CommandCompletion(value="hand|all|1|64 1 0|1 0|100000 0|60")
    @Syntax(value="[amount] [price] [increment] [autobuy] [time]")
    public void start(Player player, String amount, double price, @Default(value="0") double increment, @Default(value="0") double autoBuyPrice, @Default(value="0") int time) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                this.auctionController.withSync(() -> this.startAuction(player, auctionPlayer, amount, price, increment, autoBuyPrice, time, false));
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    @Subcommand(value="startsealed|ss")
    @CommandPermission(value="ezauctions.auction.start.sealed")
    @CommandCompletion(value="hand|all|1|64 1 1 0|100000 0|60")
    @Syntax(value="[amount] [price] [increment] [autobuy] [time]")
    public void startSealed(Player player, String amount, double price, @Default(value="0") double increment, @Default(value="0") double autoBuyPrice, @Default(value="0") int time) {
        if (!this.config.getConfig().getBoolean("sealed-auctions.enabled")) {
            this.messages.sendMessage((CommandSender)player, "command.auction.startsealed.disabled", new TagResolver[0]);
            return;
        }
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                this.auctionController.withSync(() -> this.startAuction(player, auctionPlayer, amount, price, increment, autoBuyPrice, time, true));
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    private void startAuction(Player player, AuctionPlayer auctionPlayer, String amount, double price, double increment, double autoBuyPrice, int time, boolean sealed) {
        if (!this.auctionController.isAuctionsEnabled()) {
            this.messages.sendMessage((CommandSender)player, "command.auction.start.disabled", new TagResolver[0]);
            return;
        }
        if (!auctionPlayer.withinBoundary(this.config)) {
            this.messages.sendMessage((CommandSender)player, "command.auction.start.outside_boundary", new TagResolver[0]);
            return;
        }
        if (this.reachedQueueLimit(player)) {
            return;
        }
        double fee = this.config.getConfig().getDouble("auctions.fees.start-price");
        if (fee != 0.0 && !this.economy.has((OfflinePlayer)player, fee)) {
            this.messages.sendMessage((CommandSender)player, "command.auction.start.lacking_fee", new TagResolver[0]);
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        AuctionData auctionData = new AuctionData(auctionPlayer, item, amount, time, price, increment, autoBuyPrice, sealed, player.getWorld().getName());
        auctionData.gatherAdditionalData(this.logger);
        auctionData.fillDefaults(this.config);
        if (!auctionData.validate(this.config, this.messages, player)) {
            return;
        }
        AuctionQueueEvent event = new AuctionQueueEvent(auctionData);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.auctionController.setCooldown(player.getUniqueId());
        this.economy.withdrawPlayer((OfflinePlayer)player, fee);
        ItemHelper.removeItemFromPlayerInventory(player, auctionData.getItem(), auctionData.getAmount());
        if (this.auctionController.queueAuction(auctionData)) {
            int position = this.auctionController.getPositionInQueue(auctionData);
            this.messages.sendMessage((CommandSender)player, "command.auction.start.added_to_queue", Formatter.number("position", position));
        }
    }

    @Subcommand(value="reload")
    @CommandPermission(value="ezauctions.auction.reload")
    public void reload(CommandSender sender) {
        this.scheduler.runAsyncTask(() -> {
            try {
                this.config.reload();
            }
            catch (Exception e) {
                this.logger.severe("Could not load config file!", e);
                sender.sendMessage((Component)Component.text("Failed to load configuration file. Please check the console for more information."));
                return;
            }
            try {
                this.messages.reload();
            }
            catch (Exception e) {
                this.logger.severe("Could not load messages file!", e);
                sender.sendMessage((Component)Component.text("Failed to load messages file. Please check the console for more information."));
                return;
            }
            try {
                this.database.reconnect();
            }
            catch (Exception e) {
                this.logger.severe("Could not connect to database!", e);
                sender.sendMessage((Component)Component.text("Failed to connect to database. Please check the console for more information."));
                return;
            }
            this.messages.sendMessage(sender, "command.auction.reload", new TagResolver[0]);
        });
    }

    @Subcommand(value="update")
    @CommandPermission(value="ezauctions.auction.update")
    public void update(CommandSender sender) {
        this.scheduler.runAsyncTask(() -> {
            this.messages.sendMessage(sender, "command.auction.update.checking", new TagResolver[0]);
            try {
                this.updateController.fetchLatestSupportedVersion();
                String latestVersion = this.updateController.getLatestSupportedPluginVersion();
                String serverVersion = this.updateController.getServerPluginVersion();
                if (latestVersion == null || latestVersion.equals(serverVersion)) {
                    if (latestVersion == null) {
                        latestVersion = serverVersion;
                    }
                    this.messages.sendMessage(sender, "command.auction.update.already_up_to_date", Placeholder.unparsed("latestversion", latestVersion), Placeholder.unparsed("serverversion", serverVersion));
                    return;
                }
                this.messages.sendMessage(sender, "command.auction.update.latest_version", Placeholder.unparsed("latestversion", latestVersion), Placeholder.unparsed("serverversion", serverVersion));
                this.updateController.downloadLatestSupportedVersion();
                this.messages.sendMessage(sender, "command.auction.update.downloaded", Placeholder.unparsed("latestversion", latestVersion), Placeholder.unparsed("serverversion", serverVersion));
            }
            catch (Exception e) {
                this.logger.warning("Error while updating plugin", e);
                this.messages.sendMessage(sender, "command.auction.update.error", new TagResolver[0]);
            }
        });
    }

    private boolean reachedQueueLimit(Player player) {
        boolean currentAuctioneer;
        Collection<AuctionData> queue = this.auctionController.getAuctionQueue();
        if (queue.size() >= this.config.getConfig().getInt("general.auction-queue-limit") && queue.size() >= AuctionCommand.getPermissionLimit(player, QUEUE_LIMIT_PERM_PATTERN)) {
            this.messages.sendMessage((CommandSender)player, "command.auction.start.queue_full", new TagResolver[0]);
            return true;
        }
        Auction activeAuction = this.auctionController.getActiveAuction();
        long queuedByPlayer = queue.stream().filter(d -> d.getAuctioneer().getUniqueId().equals(player.getUniqueId())).count();
        boolean bl = currentAuctioneer = activeAuction != null && activeAuction.getAuctionData().getAuctioneer().getUniqueId().equals(player.getUniqueId());
        if ((queuedByPlayer != 0L || currentAuctioneer) && queuedByPlayer >= (long)AuctionCommand.getPermissionLimit(player, CURRENT_LIMIT_PERM_PATTERN)) {
            this.messages.sendMessage((CommandSender)player, "command.auction.start.in_queue", new TagResolver[0]);
            return true;
        }
        if (this.auctionController.hasCooldown(player.getUniqueId()) && !player.hasPermission("ezauctions.cooldownexempt")) {
            long timeRequiredToWait = this.config.getConfig().getLong("general.queue-cooldown-time");
            long timeSinceLastAuction = this.auctionController.getCooldownTime(player.getUniqueId());
            long timeStillNeededToWait = timeRequiredToWait * 1000L - timeSinceLastAuction;
            long minutes = timeStillNeededToWait / 1000L / 60L;
            long seconds = timeStillNeededToWait / 1000L % 60L;
            if (minutes > 0L) {
                this.messages.sendMessage((CommandSender)player, "command.auction.start.cooldown.time_minutes", Formatter.number("seconds", seconds), Formatter.number("minutes", minutes));
            } else {
                this.messages.sendMessage((CommandSender)player, "command.auction.start.cooldown.time_seconds", Formatter.number("seconds", seconds));
            }
            return true;
        }
        return false;
    }
}

