/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.command;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutionException;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.acf.BaseCommand;
import me.elian.ezauctions.acf.annotation.CommandAlias;
import me.elian.ezauctions.acf.annotation.CommandPermission;
import me.elian.ezauctions.acf.annotation.Default;
import me.elian.ezauctions.acf.annotation.Description;
import me.elian.ezauctions.controller.AuctionController;
import me.elian.ezauctions.controller.AuctionPlayerController;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.event.AuctionBidEvent;
import me.elian.ezauctions.model.Auction;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.Bid;
import me.elian.ezauctions.model.BidList;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@Singleton
@CommandAlias(value="bid|b")
@CommandPermission(value="ezauctions.bid")
@Description(value="Bid on an auction")
public class BidCommand
extends BaseCommand {
    private final AuctionController auctionController;
    private final AuctionPlayerController playerController;
    private final ConfigController config;
    private final MessageController messages;
    private final Plugin plugin;
    private final Logger logger;
    private final Economy economy;
    private final TaskScheduler scheduler;

    @Inject
    public BidCommand(AuctionController auctionController, AuctionPlayerController playerController, ConfigController config, MessageController messages, Plugin plugin, Logger logger, Economy economy, TaskScheduler scheduler) {
        this.auctionController = auctionController;
        this.playerController = playerController;
        this.config = config;
        this.messages = messages;
        this.plugin = plugin;
        this.logger = logger;
        this.economy = economy;
        this.scheduler = scheduler;
    }

    @Default
    public void bid(Player player, @Default(value="0") double amount) {
        this.scheduler.runAsyncPlayerCommandTask(player, () -> {
            if (amount < 0.0) {
                this.messages.sendMessage((CommandSender)player, "command.bid.invalid_amount", new TagResolver[0]);
                return;
            }
            Auction activeAuction = this.auctionController.getActiveAuction();
            if (activeAuction == null) {
                this.messages.sendMessage((CommandSender)player, "command.no_current_auction", new TagResolver[0]);
                return;
            }
            String playerWorld = player.getWorld().getName();
            if (this.config.getConfig().getStringList("auctions.blocked-worlds").stream().anyMatch(playerWorld::equalsIgnoreCase)) {
                this.messages.sendAuctionMessage((CommandSender)player, "command.bid.blocked_world", activeAuction, Placeholder.unparsed("playerworld", playerWorld));
                return;
            }
            if (this.config.getConfig().getBoolean("auctions.per-world-auctions") && !playerWorld.equals(activeAuction.getAuctionData().getWorld())) {
                this.messages.sendAuctionMessage((CommandSender)player, "command.bid.wrong_world", activeAuction, Placeholder.unparsed("playerworld", playerWorld));
                return;
            }
            if (activeAuction.getAuctionData().getAuctioneer().getUniqueId().equals(player.getUniqueId())) {
                this.messages.sendAuctionMessage((CommandSender)player, "command.bid.self_bid", activeAuction, new TagResolver[0]);
                return;
            }
            try {
                AuctionPlayer auctionPlayer = this.playerController.getPlayer(player).get();
                if (!auctionPlayer.withinBoundary(this.config)) {
                    this.messages.sendAuctionMessage((CommandSender)player, "command.bid.outside_boundary", activeAuction, new TagResolver[0]);
                    return;
                }
                activeAuction.getBidList().withSync(() -> this.tryPlaceBid(player, auctionPlayer, activeAuction, amount));
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.severe("Failed to complete player command!", e);
            }
        });
    }

    private void tryPlaceBid(Player player, AuctionPlayer auctionPlayer, Auction activeAuction, double amount) {
        int numberOfBids;
        double pow;
        BidList bidList = activeAuction.getBidList();
        double minimumRequiredAmount = bidList.getMinimumRequiredBid(auctionPlayer);
        if (amount == 0.0) {
            amount = minimumRequiredAmount;
        }
        if ((amount = (double)Math.round(amount * (pow = Math.pow(10.0, this.config.getConfig().getInt("auctions.decimal.bid")))) / pow) < minimumRequiredAmount) {
            this.messages.sendMessage((CommandSender)player, "command.bid.too_low", Formatter.number("requiredamount", minimumRequiredAmount));
            return;
        }
        double autoBuyPrice = activeAuction.getAuctionData().getAutoBuyPrice();
        if (autoBuyPrice != 0.0 && amount > autoBuyPrice) {
            amount = autoBuyPrice;
        }
        if (activeAuction.getAuctionData().isSealed() && (numberOfBids = bidList.getNumberOfBids(auctionPlayer)) == this.config.getConfig().getInt("sealed-auctions.max-bids")) {
            this.messages.sendAuctionMessage((CommandSender)player, "command.bid.max-bids", activeAuction, Formatter.number("maxbidsamount", numberOfBids));
            return;
        }
        int consecutiveBids = bidList.getConsecutiveBids(auctionPlayer);
        int maxConsecutiveBids = this.config.getConfig().getInt("auctions.maximum.consecutive-bids");
        if (maxConsecutiveBids != 0 && consecutiveBids == maxConsecutiveBids) {
            this.messages.sendAuctionMessage((CommandSender)player, "command.bid.consecutive_limit", activeAuction, Formatter.number("consecutivelimit", consecutiveBids));
            return;
        }
        Bid highestBidForPlayer = bidList.getHighestBidForPlayer(auctionPlayer);
        double existingBidAmount = highestBidForPlayer == null ? 0.0 : highestBidForPlayer.amount();
        double amountToRemove = amount - existingBidAmount;
        if (this.economy.getBalance(auctionPlayer.getOfflinePlayer()) < amountToRemove) {
            this.messages.sendAuctionMessage((CommandSender)player, "command.bid.lacking_money", activeAuction, Formatter.number("requiredamount", amountToRemove));
            return;
        }
        Bid bid = new Bid(auctionPlayer, amount);
        AuctionBidEvent event = new AuctionBidEvent(activeAuction, bid);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.economy.withdrawPlayer(auctionPlayer.getOfflinePlayer(), amountToRemove);
        bidList.placeBid(bid);
        this.messages.sendAuctionMessage((CommandSender)player, "command.bid.placed", activeAuction, new TagResolver[0]);
        if (!activeAuction.getAuctionData().isSealed()) {
            this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), activeAuction, true, "auction.bid", new TagResolver[0]);
        }
    }
}

