/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.controller;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.controller.AuctionPlayerController;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.helper.ItemHelper;
import me.elian.ezauctions.model.Auction;
import me.elian.ezauctions.model.AuctionData;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class AuctionController
implements Listener {
    private final Logger logger;
    private final AuctionPlayerController playerController;
    private final TaskScheduler scheduler;
    private final ConfigController config;
    private final MessageController messages;
    private final Provider<Auction> auctionProvider;
    private final Queue<AuctionData> auctionQueue = new LinkedList<AuctionData>();
    private final Map<UUID, Long> queueCooldown = new HashMap<UUID, Long>();
    private boolean auctionsEnabled = true;
    private Auction activeAuction;
    private long lastAuctionEndTimeMillis;

    @Inject
    public AuctionController(Plugin plugin, Logger logger, AuctionPlayerController playerController, TaskScheduler scheduler, ConfigController config, MessageController messages, Provider<Auction> auctionProvider) {
        this.logger = logger;
        this.playerController = playerController;
        this.scheduler = scheduler;
        this.config = config;
        this.messages = messages;
        this.auctionProvider = auctionProvider;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public boolean isAuctionsEnabled() {
        return this.auctionsEnabled;
    }

    public void setAuctionsEnabled(boolean auctionsEnabled) {
        this.auctionsEnabled = auctionsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withSync(Runnable runnable) {
        AuctionController auctionController = this;
        synchronized (auctionController) {
            runnable.run();
        }
    }

    @NotNull
    public Collection<AuctionData> getAuctionQueue() {
        return Collections.unmodifiableCollection(this.auctionQueue);
    }

    public boolean hasActiveAuction() {
        return this.activeAuction != null;
    }

    @Nullable
    public Auction getActiveAuction() {
        return this.activeAuction;
    }

    public long getCooldownTime(@NotNull UUID uniqueId) {
        return this.queueCooldown.getOrDefault(uniqueId, 0L);
    }

    public boolean hasCooldown(@NotNull UUID uniqueId) {
        long cooldown;
        if (!this.queueCooldown.containsKey(uniqueId)) {
            return false;
        }
        long time = this.queueCooldown.get(uniqueId);
        long timeSince = System.currentTimeMillis() - time;
        if (timeSince >= (cooldown = this.config.getConfig().getLong("general.queue-cooldown-time"))) {
            this.queueCooldown.remove(uniqueId);
            return false;
        }
        return false;
    }

    public void setCooldown(@NotNull UUID uniqueId) {
        this.queueCooldown.put(uniqueId, System.currentTimeMillis());
    }

    public int getPositionInQueue(@NotNull AuctionData auctionData) {
        int position = 1;
        for (AuctionData data : this.auctionQueue) {
            if (data == auctionData) {
                return position;
            }
            ++position;
        }
        return 0;
    }

    @Nullable
    public AuctionData removeFirstItemFromQueue(@NotNull AuctionPlayer auctionPlayer) {
        for (AuctionData data : this.auctionQueue) {
            if (!data.getAuctioneer().getUniqueId().equals(auctionPlayer.getUniqueId())) continue;
            this.auctionQueue.remove(data);
            this.logItemMessage(data, "Item removed from auction queue. Auctioneer: %s Amount: %d Item: %s NBT: %s");
            return data;
        }
        return null;
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent e) {
        UUID id = e.getPlayer().getUniqueId();
        Auction activeAuction = this.getActiveAuction();
        if (activeAuction == null) {
            return;
        }
        if (!activeAuction.getAuctionData().getAuctioneer().getUniqueId().equals(id) && !activeAuction.getBidList().playerHasAnyBids(id)) {
            return;
        }
        String command = e.getMessage().split(" ")[0];
        for (String blockedCommand : this.config.getConfig().getStringList("auctions.blocked-commands")) {
            if (!command.equalsIgnoreCase("/" + blockedCommand)) continue;
            e.setCancelled(true);
            this.messages.sendAuctionMessage((CommandSender)e.getPlayer(), "auction.blocked_command", activeAuction, new TagResolver[0]);
            return;
        }
    }

    public boolean queueAuction(@NotNull AuctionData auctionData) {
        Auction auction;
        if (this.hasActiveAuction() || this.auctionQueue.size() != 0) {
            this.auctionQueue.add(auctionData);
            this.logItemMessage(auctionData, "Item added to auction queue. Auctioneer: %s Amount: %d Item: %s NBT: %s");
            return true;
        }
        int delay = this.config.getConfig().getInt("general.time-between");
        long timeSinceLastAuction = System.currentTimeMillis() - this.lastAuctionEndTimeMillis;
        if (timeSinceLastAuction < (long)delay * 1000L) {
            this.auctionQueue.add(auctionData);
            this.logItemMessage(auctionData, "Item added to auction queue. Auctioneer: %s Amount: %d Item: %s NBT: %s");
            this.pullNextAuctionFromQueue();
            return true;
        }
        this.activeAuction = auction = this.auctionProvider.get();
        auction.startAuction(auctionData, this::handleAuctionCompleted);
        this.logItemMessage(auctionData, "Item starting in auction. Auctioneer: %s Amount: %d Item: %s NBT: %s");
        return false;
    }

    public void shutdown() {
        for (AuctionData queued : this.auctionQueue) {
            queued.addSavedItemToPlayer(queued.getAuctioneer(), this.playerController, this.scheduler);
        }
        this.auctionQueue.clear();
        Auction activeAuction = this.getActiveAuction();
        if (activeAuction != null) {
            activeAuction.cancelAuctionShutdown();
        }
    }

    private void handleAuctionCompleted() {
        this.activeAuction = null;
        this.lastAuctionEndTimeMillis = System.currentTimeMillis();
        this.withSync(this::pullNextAuctionFromQueue);
    }

    private void pullNextAuctionFromQueue() {
        long timeSinceLastAuction;
        if (this.auctionQueue.isEmpty()) {
            return;
        }
        int delay = this.config.getConfig().getInt("general.time-between");
        if (this.lastAuctionEndTimeMillis != 0L && (timeSinceLastAuction = (System.currentTimeMillis() - this.lastAuctionEndTimeMillis) / 1000L) < (long)delay) {
            delay = (int)((long)delay - timeSinceLastAuction);
        }
        this.scheduler.runAsyncDelayedTask(() -> this.withSync(this::startNextAuctionFromQueue), delay);
    }

    private void startNextAuctionFromQueue() {
        Auction nextAuction;
        if (this.auctionQueue.isEmpty()) {
            return;
        }
        AuctionData nextAuctionData = this.auctionQueue.remove();
        this.activeAuction = nextAuction = this.auctionProvider.get();
        nextAuction.startAuction(nextAuctionData, this::handleAuctionCompleted);
        this.logItemMessage(nextAuctionData, "Item starting in auction. Auctioneer: %s Amount: %d Item: %s NBT: %s");
    }

    private void logItemMessage(AuctionData data, String message) {
        String itemNbt;
        if (!this.config.getConfig().getBoolean("general.log-items-to-console")) {
            return;
        }
        try {
            itemNbt = ItemHelper.getItemNBT(data.getItem());
        }
        catch (Exception e) {
            this.logger.warning("Unable to get auction item's NBT! Exception: " + String.valueOf(e));
            itemNbt = "{}";
        }
        this.logger.info(String.format(message, data.getAuctioneer().getOfflinePlayer().getName(), data.getAmount(), data.getItem().getType(), itemNbt));
    }
}

