/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.controller;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.controller.ScoreboardController;
import me.elian.ezauctions.data.Database;
import me.elian.ezauctions.helper.ItemHelper;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.SavedItem;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Singleton
public class AuctionPlayerController
implements Listener {
    private final Logger logger;
    private final Database database;
    private final TaskScheduler scheduler;
    private final ConfigController config;
    private final MessageController messages;
    private final ScoreboardController scoreboard;
    private final Set<AuctionPlayer> onlinePlayers = Sets.newConcurrentHashSet();

    @Inject
    public AuctionPlayerController(Plugin plugin, Logger logger, Database database, TaskScheduler scheduler, ConfigController config, MessageController messages, ScoreboardController scoreboard) {
        this.logger = logger;
        this.database = database;
        this.scheduler = scheduler;
        this.config = config;
        this.messages = messages;
        this.scoreboard = scoreboard;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        scheduler.runAsyncTask(() -> {
            for (Player player : plugin.getServer().getOnlinePlayers()) {
                database.getAuctionPlayer(player.getUniqueId()).thenAccept(this.onlinePlayers::add);
            }
        });
    }

    @NotNull
    public CompletableFuture<AuctionPlayer> getPlayer(@NotNull Player player) {
        return this.getPlayer(player.getUniqueId());
    }

    @NotNull
    public CompletableFuture<AuctionPlayer> getPlayer(@NotNull UUID id) {
        for (AuctionPlayer ap : this.onlinePlayers) {
            if (!ap.getUniqueId().equals(id)) continue;
            return CompletableFuture.completedFuture(ap);
        }
        return this.database.getAuctionPlayer(id);
    }

    @NotNull
    public CompletableFuture<AuctionPlayer> getPlayerFromDatabase(@NotNull UUID id) {
        return this.database.getAuctionPlayer(id);
    }

    public void savePlayer(@NotNull AuctionPlayer auctionPlayer) {
        this.scheduler.runAsyncTask(() -> this.database.saveAuctionPlayer(auctionPlayer));
    }

    @NotNull
    public Set<AuctionPlayer> getOnlinePlayers() {
        return Collections.unmodifiableSet(this.onlinePlayers);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.scheduler.runAsyncTask(() -> {
            Player p = e.getPlayer();
            UUID id = p.getUniqueId();
            this.database.getAuctionPlayer(id).thenAccept(ap -> {
                this.onlinePlayers.add((AuctionPlayer)ap);
                this.scoreboard.addPlayer(p);
                this.returnSavedItems((AuctionPlayer)ap);
            });
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        UUID id = e.getPlayer().getUniqueId();
        for (AuctionPlayer ap : this.onlinePlayers) {
            if (!ap.getUniqueId().equals(id)) continue;
            this.onlinePlayers.remove(ap);
            break;
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent e) {
        this.scheduler.runAsyncTask(() -> {
            Player player = e.getPlayer();
            this.getPlayerFromDatabase(player.getUniqueId()).thenAccept(this::returnSavedItems);
        });
    }

    private void returnSavedItems(AuctionPlayer ap) {
        if (ap.getSavedItems() == null || ap.getSavedItems().isEmpty()) {
            return;
        }
        Player p = ap.getOnlinePlayer();
        if (p == null) {
            return;
        }
        this.scheduler.runPlayerRegionTask(() -> {
            ArrayList<SavedItem> returnedItems = new ArrayList<SavedItem>();
            boolean overflow = false;
            String playerWorld = p.getWorld().getName();
            if (this.config.getConfig().getStringList("auctions.blocked-worlds").stream().anyMatch(blockedWorld -> blockedWorld.equals(playerWorld))) {
                this.messages.sendMessage((CommandSender)p, "reward.relogged_blocked_world", new TagResolver[0]);
                return;
            }
            for (SavedItem savedItem : ap.getSavedItems()) {
                if (this.config.getConfig().getBoolean("auctions.per-world-auctions") && !playerWorld.equals(savedItem.getWorld())) {
                    this.messages.sendMessage((CommandSender)p, "reward.relogged_wrong_world", Placeholder.unparsed("itemworld", savedItem.getWorld()));
                    continue;
                }
                try {
                    ItemStack item = savedItem.getItemStack();
                    boolean itemOverflowed = ItemHelper.addItemToPlayerInventory(p, item, savedItem.getAmount());
                    if (itemOverflowed) {
                        overflow = true;
                    }
                }
                catch (IOException e) {
                    this.logger.severe("Error occured while deserializing item stack! Player item not returned! " + savedItem.getSerializedItemJson(), e);
                }
                returnedItems.add(savedItem);
            }
            if (returnedItems.size() == 0) {
                return;
            }
            this.scheduler.runAsyncTask(() -> ap.getSavedItems().removeAll(returnedItems));
            this.messages.sendMessage((CommandSender)p, "reward.relogged", new TagResolver[0]);
            if (overflow) {
                this.messages.sendMessage((CommandSender)p, "reward.full_inventory", new TagResolver[0]);
            }
        }, p);
    }
}

