/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.controller;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.Reader;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.controller.FileHandler;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ConfigController
extends FileHandler {
    private static final String RESOURCE_NAME = "config.yml";
    private FileConfiguration fileConfiguration;

    @Inject
    public ConfigController(Plugin plugin, Logger logger) {
        super(plugin, logger, RESOURCE_NAME);
        try {
            this.reload();
        }
        catch (IOException e) {
            logger.severe("Could not load config file!", e);
        }
    }

    @Override
    protected void loadFile(@NotNull Reader reader) {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
    }

    @NotNull
    public FileConfiguration getConfig() {
        return this.fileConfiguration;
    }
}

