/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import me.elian.ezauctions.Logger;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

abstract class FileHandler {
    private final Logger logger;
    private final String resourceName;
    private final Path path;

    protected FileHandler(Plugin plugin, Logger logger, String resourceName) {
        this.logger = logger;
        this.resourceName = resourceName;
        this.path = Path.of(plugin.getDataFolder().getPath(), resourceName);
    }

    private void createFileFromResource() throws IOException, SecurityException {
        if (this.path.toFile().exists()) {
            return;
        }
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(this.resourceName);){
            if (input == null) {
                throw new IOException("Invalid resource name!");
            }
            File parent = this.path.toFile().getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("Could not create parent directory!");
            }
            Files.copy(input, this.path, new CopyOption[0]);
        }
    }

    protected abstract void loadFile(@NotNull Reader var1);

    public void reload() throws IOException {
        try {
            this.createFileFromResource();
            File file = this.path.toFile();
            try (FileInputStream inputStream = new FileInputStream(file);
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                this.loadFile(reader);
            }
        }
        catch (IOException | SecurityException e) {
            this.logger.severe("Could not create file " + this.resourceName + "! Check disk space and directory permissions! Using default configuration!", e);
            this.loadDefaultFile();
            throw new IOException();
        }
    }

    private void loadDefaultFile() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.resourceName);){
            if (inputStream == null) {
                throw new IOException();
            }
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                this.loadFile(reader);
            }
        }
        catch (IOException e) {
            this.logger.severe("Could not load resource " + this.resourceName + "!!! The plugin will not work correctly.", e);
        }
    }
}

