/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.controller;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.acf.PaperCommandManager;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.FileHandler;
import me.elian.ezauctions.helper.ItemHelper;
import me.elian.ezauctions.locales.MessageKey;
import me.elian.ezauctions.model.Auction;
import me.elian.ezauctions.model.AuctionData;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.Bid;
import me.elian.ezauctions.model.BidList;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.StyleSetter;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.milkbowl.vault.economy.Economy;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class MessageController
extends FileHandler {
    private static final String RESOURCE_NAME = "messages.properties";
    private static final Pattern HAS_CUSTOM_NAME_PATTERN = Pattern.compile("<hascustomname>(.*)</hascustomname>", 32);
    private static final Pattern NO_CUSTOM_NAME_PATTERN = Pattern.compile("<nocustomname>(.*)</nocustomname>", 32);
    private static final Pattern SKULL_PATTERN = Pattern.compile("<skull>(.*)</skull>", 32);
    private static final Pattern AUTOBUY_PATTERN = Pattern.compile("<autobuy>(.*)</autobuy>", 32);
    private static final Pattern SEALED_PATTERN = Pattern.compile("<sealed>(.*)</sealed>", 32);
    private static final Pattern REPAIR_PATTERN = Pattern.compile("<repair>(.*)</repair>", 32);
    private static final Pattern UNREPAIRABLE_PATTERN = Pattern.compile("<unrepairable>(.*)</unrepairable>", 32);
    private final Plugin plugin;
    private final Logger logger;
    private final PaperCommandManager commandManager;
    private final ConfigController config;
    private final Economy economy;
    private ResourceBundle bundle;
    private BukkitAudiences audiences;
    private String prefixRaw;

    @Inject
    public MessageController(Plugin plugin, Logger logger, PaperCommandManager commandManager, ConfigController config, Economy economy) {
        super(plugin, logger, RESOURCE_NAME);
        this.plugin = plugin;
        this.logger = logger;
        this.commandManager = commandManager;
        this.config = config;
        this.economy = economy;
        try {
            this.reload();
        }
        catch (IOException e) {
            logger.severe("Could not load messages file!", e);
        }
        try {
            Player.class.getMethod("sendMessage", Component.class);
        }
        catch (NoSuchMethodException e) {
            this.audiences = BukkitAudiences.create(plugin);
        }
    }

    public void shutdown() {
        if (this.audiences != null) {
            this.audiences.close();
        }
    }

    public void sendMessage(@Nullable CommandSender target, @NotNull String key, TagResolver ... resolvers) {
        if (target == null) {
            return;
        }
        Component message = this.getComponentMessage(key, resolvers);
        this.sendComponentToSender(target, message);
    }

    public void sendAuctionMessage(@Nullable CommandSender target, @NotNull String key, @NotNull Auction auction, TagResolver ... resolvers) {
        if (target == null) {
            return;
        }
        Component message = this.getAuctionComponent(this.getRawMessage(key), auction.getAuctionData(), auction.getBidList(), auction.getRemainingSeconds(), resolvers);
        this.sendComponentToSender(target, message);
    }

    public void sendAuctionMessage(@Nullable CommandSender target, @NotNull String key, @NotNull AuctionData data, TagResolver ... resolvers) {
        if (target == null) {
            return;
        }
        Component message = this.getAuctionComponent(this.getRawMessage(key), data, null, data.getStartingAuctionTime(), resolvers);
        this.sendComponentToSender(target, message);
    }

    public void broadcastAuctionMessage(@NotNull Set<AuctionPlayer> onlinePlayers, @NotNull Auction auction, boolean spammy, @NotNull String key, TagResolver ... resolvers) {
        UUID auctioneerId = auction.getAuctionData().getAuctioneer().getUniqueId();
        String world = auction.getAuctionData().getWorld();
        Component message = this.getAuctionComponent(this.getRawMessage(key), auction.getAuctionData(), auction.getBidList(), auction.getRemainingSeconds(), resolvers);
        for (AuctionPlayer ap : onlinePlayers) {
            Player target;
            if (ap.isIgnoringAll() || spammy && ap.isIgnoringSpammy() || ap.getIgnoredPlayers() != null && ap.getIgnoredPlayers().stream().anyMatch(ip -> ip.getIgnored().equals(auctioneerId)) || (target = ap.getOnlinePlayer()) == null) continue;
            String playerWorld = target.getWorld().getName();
            if (this.config.getConfig().getBoolean("auctions.per-world-broadcast") && world != null && !world.equals(playerWorld)) continue;
            this.sendComponentToSender((CommandSender)target, message);
        }
        this.sendComponentToSender((CommandSender)this.plugin.getServer().getConsoleSender(), message);
    }

    public List<Component> getAuctionComponentLines(@NotNull String key, @NotNull Auction auction, TagResolver ... extraResolvers) {
        String raw = this.getRawMessage(key);
        if (raw == null) {
            return new ArrayList<Component>();
        }
        String booleansReplaced = this.replaceAuctionPatterns(raw, auction.getAuctionData());
        Object[] tagResolvers = this.getAuctionTagResolvers(auction.getAuctionData(), auction.getBidList(), auction.getRemainingSeconds());
        TagResolver[] mergedResolvers = (TagResolver[])ArrayUtils.addAll((Object[])tagResolvers, (Object[])extraResolvers);
        return Arrays.stream(booleansReplaced.split("\n")).map(s2 -> {
            try {
                return MiniMessage.miniMessage().deserialize((String)s2, mergedResolvers);
            }
            catch (Exception e) {
                this.logger.severe("Error parsing message! Auction broadcast will not work correctly! " + key, e);
                return LegacyComponentSerializer.legacyAmpersand().deserialize((String)s2);
            }
        }).collect(Collectors.toList());
    }

    private Component getAuctionComponent(String rawMessage, AuctionData data, @Nullable BidList bidList, int remainingSeconds, TagResolver ... extraResolvers) {
        Component parsed;
        if (rawMessage == null) {
            return Component.empty();
        }
        String message = this.replaceAuctionPatterns(rawMessage, data);
        Object[] tagResolvers = this.getAuctionTagResolvers(data, bidList, remainingSeconds);
        TagResolver[] mergedResolvers = (TagResolver[])ArrayUtils.addAll((Object[])tagResolvers, (Object[])extraResolvers);
        try {
            parsed = MiniMessage.miniMessage().deserialize(message, mergedResolvers);
            parsed = this.reconstructAuctionComponentRecursive(parsed, data);
        }
        catch (Exception e) {
            this.logger.severe("Error parsing message! Auction broadcast will not work correctly!\n" + rawMessage, e);
            parsed = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        }
        return parsed;
    }

    private Component reconstructAuctionComponentRecursive(Component component, AuctionData data) {
        HoverEvent.ShowItem showItem;
        HoverEvent<?> hoverEvent;
        StyleSetter<Component> returnComponent = component;
        List<Component> childrenUnmodifiable = component.children();
        if (!childrenUnmodifiable.isEmpty()) {
            ArrayList<Component> children = new ArrayList<Component>(childrenUnmodifiable.size());
            for (Component child : childrenUnmodifiable) {
                children.add(this.reconstructAuctionComponentRecursive(child, data));
            }
            returnComponent = returnComponent.children(children);
        }
        if ((hoverEvent = component.hoverEvent()) != null && hoverEvent.action().type() == HoverEvent.ShowItem.class && (showItem = (HoverEvent.ShowItem)hoverEvent.value()).item().compareTo(data.getItemKey()) == 0 && (showItem.nbt() == null || showItem.nbt().string().isEmpty())) {
            HoverEvent<HoverEvent.ShowItem> newHoverEvent = ItemHelper.getItemHover(data.getItem(), initialEvent -> initialEvent.item(data.getItemKey()).count(Math.min(data.getAmount(), data.getItem().getMaxStackSize())));
            returnComponent = returnComponent.hoverEvent(newHoverEvent);
        }
        return returnComponent;
    }

    private TagResolver[] getAuctionTagResolvers(AuctionData data, BidList bidList, int remainingSeconds) {
        Bid highestBid;
        ItemStack item = data.getItem();
        String auctioneerName = data.getAuctioneer().getOfflinePlayer().getName();
        if (auctioneerName == null) {
            auctioneerName = "";
        }
        double highestBidAmount = data.getStartingPrice();
        String highestBidderName = null;
        String highestBidderUniqueId = "";
        if (bidList != null && (highestBid = bidList.getHighestBid()) != null && !data.isSealed()) {
            highestBidAmount = highestBid.amount();
            highestBidderName = highestBid.auctionPlayer().getOfflinePlayer().getName();
            highestBidderUniqueId = highestBid.auctionPlayer().getUniqueId().toString();
        }
        if (highestBidderName == null) {
            highestBidderName = "";
        }
        return new TagResolver[]{Placeholder.unparsed("auctioneer", auctioneerName), Placeholder.unparsed("auctioneeruuid", data.getAuctioneer().getUniqueId().toString()), Formatter.number("itemamount", data.getAmount()), Placeholder.unparsed("minecraftname", data.getMinecraftName()), Placeholder.unparsed("customname", data.getCustomName()), Placeholder.unparsed("materialtype", item.getType().toString().toLowerCase()), Formatter.number("startingprice", data.getStartingPrice()), Formatter.number("highestbidamount", highestBidAmount), Placeholder.unparsed("highestbidder", highestBidderName), Placeholder.unparsed("highestbidderuuid", highestBidderUniqueId), Formatter.number("increment", data.getIncrementPrice()), Formatter.number("starttime", data.getStartingAuctionTime()), Formatter.number("remainingtime", remainingSeconds), Formatter.number("autobuy", data.getAutoBuyPrice()), Placeholder.unparsed("world", data.getWorld()), Placeholder.unparsed("skullowner", data.getSkullOwner()), Formatter.number("repairprice", data.getRepairPrice()), Formatter.number("antisnipetime", this.config.getConfig().getInt("antisnipe.time")), Placeholder.unparsed("currencynameplural", this.economy.currencyNamePlural()), Placeholder.unparsed("currencynamesingular", this.economy.currencyNameSingular())};
    }

    private Component getComponentMessage(String key, TagResolver ... resolvers) {
        Component parsed;
        String message = this.getRawMessage(key);
        if (message == null) {
            return Component.text().build();
        }
        try {
            parsed = MiniMessage.miniMessage().deserialize(message, resolvers);
        }
        catch (Exception e) {
            this.logger.warning("Message key " + key + " not in valid MiniMessage format! Falling back to legacy text.", e);
            parsed = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        }
        return parsed;
    }

    private String getLegacyMessage(String key, TagResolver ... resolvers) {
        Component message = this.getComponentMessage(key, resolvers);
        return LegacyComponentSerializer.legacyAmpersand().serialize(message);
    }

    @Nullable
    private String getRawMessage(String key) {
        try {
            String message = this.getStringFromBundle(key);
            if (message == null) {
                return null;
            }
            return message.replace("{prefix}", this.prefixRaw);
        }
        catch (Exception e) {
            this.logger.severe("Exception when attempting to get message! " + key);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getStringFromBundle(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException resourceException) {
            this.logger.warning("Missing message key in messages file! (" + key + ") Loading from default messages.properties. This will make the plugin slower!", resourceException);
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RESOURCE_NAME);){
                String string;
                if (inputStream == null) {
                    throw new IOException();
                }
                try (InputStreamReader reader = new InputStreamReader(inputStream);){
                    PropertyResourceBundle defaultBundle = new PropertyResourceBundle(reader);
                    string = defaultBundle.getString(key);
                }
                return string;
            }
            catch (IOException e) {
                this.logger.severe("Critical error when loading default messages.properties!", e);
                return null;
            }
        }
    }

    private String replaceAuctionPatterns(String raw, AuctionData data) {
        String replaced = raw;
        replaced = this.replaceAuctionPattern(replaced, HAS_CUSTOM_NAME_PATTERN, !data.getCustomName().equals(data.getMinecraftName()));
        replaced = this.replaceAuctionPattern(replaced, NO_CUSTOM_NAME_PATTERN, data.getCustomName().equals(data.getMinecraftName()));
        replaced = this.replaceAuctionPattern(replaced, SKULL_PATTERN, !data.getSkullOwner().isEmpty());
        replaced = this.replaceAuctionPattern(replaced, AUTOBUY_PATTERN, data.getAutoBuyPrice() != 0.0);
        replaced = this.replaceAuctionPattern(replaced, SEALED_PATTERN, data.isSealed());
        replaced = this.replaceAuctionPattern(replaced, REPAIR_PATTERN, data.getRepairPrice() > 0);
        replaced = this.replaceAuctionPattern(replaced, UNREPAIRABLE_PATTERN, data.getRepairPrice() == -1);
        replaced = replaced.replace("<auctioneeruuid>", data.getAuctioneer().getUniqueId().toString());
        replaced = replaced.replace("<highestbidderuuid>", data.getAuctioneer().getUniqueId().toString());
        replaced = replaced.replace("<materialtype>", data.getItem().getType().toString().toLowerCase());
        replaced = replaced.replace("<itemamount>", Integer.toString(data.getAmount()));
        replaced = replaced.replace("<minecraftname>", data.getMinecraftName());
        replaced = replaced.replace("<customname>", data.getCustomName());
        replaced = replaced.replace("<itemnbt>", "");
        return replaced;
    }

    private String replaceAuctionPattern(String original, Pattern pattern, boolean show) {
        Matcher matcher = pattern.matcher(original);
        String replaced = original;
        while (matcher.find()) {
            String match = original.substring(matcher.start(), matcher.end());
            if (show) {
                replaced = replaced.replace(match, matcher.group(1));
                continue;
            }
            replaced = replaced.replace(match, "");
        }
        return replaced;
    }

    private void sendComponentToSender(CommandSender target, Component component) {
        if (this.audiences == null) {
            target.sendMessage(component);
        } else {
            this.audiences.sender(target).sendMessage(component);
        }
    }

    @Override
    protected void loadFile(@NotNull Reader reader) {
        try {
            this.bundle = new PropertyResourceBundle(reader);
            this.prefixRaw = this.getStringFromBundle("prefix");
            if (this.prefixRaw == null) {
                this.prefixRaw = "";
            }
            this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKey.of("acf-core.permission_denied"), this.getLegacyMessage("command.no_perm", new TagResolver[0]));
            this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKey.of("acf-core.permission_denied_parameter"), this.getLegacyMessage("command.no_perm", new TagResolver[0]));
            this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKey.of("acf-core.error_prefix"), this.getLegacyMessage("command.error_prefix", new TagResolver[0]));
            this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKey.of("acf-core.invalid_syntax"), this.getLegacyMessage("command.usage", new TagResolver[0]));
        }
        catch (IOException e) {
            this.logger.severe("Could not load resource messages.properties! Check file permissions.");
        }
    }
}

