/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.controller;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Set;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.model.Auction;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.scheduler.TaskScheduler;
import me.elian.ezauctions.scoreboardlibrary.api.ScoreboardLibrary;
import me.elian.ezauctions.scoreboardlibrary.api.exception.NoPacketAdapterAvailableException;
import me.elian.ezauctions.scoreboardlibrary.api.noop.NoopScoreboardLibrary;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.Sidebar;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.component.ComponentSidebarLayout;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.component.SidebarComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ScoreboardController
implements Listener {
    private final TaskScheduler scheduler;
    private final ConfigController config;
    private final MessageController messages;
    private ScoreboardLibrary scoreboardLibrary;
    private Sidebar sidebar;

    @Inject
    public ScoreboardController(TaskScheduler scheduler, ConfigController config, MessageController messages, Plugin plugin) {
        this.scheduler = scheduler;
        this.config = config;
        this.messages = messages;
        try {
            this.scoreboardLibrary = ScoreboardLibrary.loadScoreboardLibrary(plugin);
        }
        catch (NoPacketAdapterAvailableException e) {
            this.scoreboardLibrary = new NoopScoreboardLibrary();
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void createForAuction(@NotNull Auction auction, @NotNull Set<AuctionPlayer> onlinePlayers) {
        if (!this.config.getConfig().getBoolean("scoreboard.enabled")) {
            return;
        }
        this.scheduler.runSyncTask(() -> {
            this.createSidebar(onlinePlayers);
            this.updateForAuction(auction);
        });
    }

    public void updateForAuction(@NotNull Auction auction) {
        this.scheduler.runSyncTask(() -> {
            if (this.sidebar == null) {
                return;
            }
            List<Component> title = this.messages.getAuctionComponentLines("auction.scoreboard.title", auction, new TagResolver[0]);
            List<Component> lines = this.messages.getAuctionComponentLines("auction.scoreboard.body", auction, new TagResolver[0]);
            SidebarComponent.Builder builder = SidebarComponent.builder();
            for (Component component : lines) {
                builder.addStaticLine(component);
            }
            TextComponent titleComponent = title.size() == 0 ? Component.empty() : title.get(0);
            SidebarComponent linesSidebarComponent = builder.build();
            ComponentSidebarLayout componentSidebar = new ComponentSidebarLayout(SidebarComponent.staticLine(titleComponent), linesSidebarComponent);
            componentSidebar.apply(this.sidebar);
        });
    }

    public void addPlayer(@NotNull Player player) {
        this.scheduler.runSyncTask(() -> {
            if (this.sidebar != null) {
                this.sidebar.addPlayer(player);
            }
        });
    }

    public void removePlayer(@NotNull Player player) {
        this.scheduler.runSyncTask(() -> {
            if (this.sidebar != null) {
                this.sidebar.removePlayer(player);
            }
        });
    }

    public void remove() {
        this.scheduler.runSyncTask(() -> {
            if (this.sidebar == null) {
                return;
            }
            this.sidebar.close();
            this.sidebar = null;
        });
    }

    public void shutdown() {
        this.scoreboardLibrary.close();
    }

    private void createSidebar(@NotNull Set<AuctionPlayer> onlinePlayers) {
        this.sidebar = this.scoreboardLibrary.createSidebar();
        for (AuctionPlayer auctionPlayer : onlinePlayers) {
            Player player = auctionPlayer.getOnlinePlayer();
            if (auctionPlayer.isIgnoringScoreboard() || player == null) continue;
            this.sidebar.addPlayer(player);
        }
    }
}

