/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.controller;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

@Singleton
public class UpdateController
implements Listener {
    private static final String GITHUB_REPO = "elian1203/ezAuctions";
    private static Thread shutdownHook;
    private static Path downloadedFilePath;
    private final Plugin plugin;
    private final TaskScheduler scheduler;
    private final Logger logger;
    private final ConfigController config;
    private final MessageController messages;
    private final String serverMinecraftVersion;
    private final String serverPluginVersion;
    private final HttpClient client;
    private String latestSupportedPluginVersion;

    @Inject
    public UpdateController(Plugin plugin, TaskScheduler scheduler, Logger logger, ConfigController config, MessageController messages) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.logger = logger;
        this.config = config;
        this.messages = messages;
        this.serverMinecraftVersion = this.getServerMinecraftVersion();
        this.serverPluginVersion = plugin.getDescription().getVersion();
        this.client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public String getServerPluginVersion() {
        return this.serverPluginVersion;
    }

    public String getLatestSupportedPluginVersion() {
        return this.latestSupportedPluginVersion;
    }

    private String getServerMinecraftVersion() {
        try {
            return (String)this.plugin.getServer().getClass().getMethod("getMinecraftVersion", new Class[0]).invoke((Object)this.plugin.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String version = this.plugin.getServer().getVersion();
            String[] spaceSplit = version.split(" ");
            return spaceSplit[2].replace("(", "").replace(")", "");
        }
    }

    public void checkForUpdates() {
        if (!this.config.getConfig().getBoolean("general.check-updates")) {
            return;
        }
        this.scheduler.runAsyncTask(() -> {
            try {
                this.fetchLatestSupportedVersion();
                if (this.latestSupportedPluginVersion == null || this.latestSupportedPluginVersion.equals(this.serverPluginVersion)) {
                    return;
                }
                this.logger.info("Version " + this.latestSupportedPluginVersion + " is available! You are currently running version " + this.serverPluginVersion + ".");
                if (this.config.getConfig().getBoolean("general.auto-update", true)) {
                    this.downloadLatestSupportedVersion();
                } else {
                    this.scheduler.runSyncTask(() -> this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.warning("Error while checking latest release of plugin.", e);
            }
        });
    }

    public void shutdown() {
        this.moveDownloadedUpdateToPluginsDir();
    }

    private boolean versionIsEqualOrNewer(String oldVersion, String newVersion) {
        ModuleDescriptor.Version oldVersionParsed;
        if (oldVersion == null || newVersion == null) {
            return false;
        }
        ModuleDescriptor.Version newVersionParsed = ModuleDescriptor.Version.parse(newVersion);
        return newVersionParsed.compareTo(oldVersionParsed = ModuleDescriptor.Version.parse(oldVersion)) >= 0;
    }

    public void fetchLatestSupportedVersion() throws ExecutionException, InterruptedException {
        String url = "https://api.github.com/repos/elian1203/ezAuctions/tags";
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).build();
        String response = (String)((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).get();
        JsonElement element = JsonParser.parseString((String)response);
        JsonArray array = element.getAsJsonArray();
        for (int index = 0; index < array.size(); ++index) {
            JsonElement tag = array.get(index);
            JsonObject object = tag.getAsJsonObject();
            String tagName = object.get("name").getAsString();
            if (!this.versionIsEqualOrNewer(this.serverPluginVersion, tagName) || !this.isTagSupported(tagName)) continue;
            this.latestSupportedPluginVersion = tagName;
            return;
        }
        this.latestSupportedPluginVersion = null;
    }

    private boolean isTagSupported(String tagName) throws ExecutionException, InterruptedException {
        String url = "https://raw.githubusercontent.com/elian1203/ezAuctions/" + tagName + "/src/main/resources/plugin.yml";
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).build();
        String response = (String)((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).get();
        StringReader reader = new StringReader(response);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
        String apiVersion = config.getString("api-version");
        return this.versionIsEqualOrNewer(apiVersion, this.serverMinecraftVersion);
    }

    public void downloadLatestSupportedVersion() throws ExecutionException, InterruptedException {
        if (downloadedFilePath != null) {
            downloadedFilePath.toFile().delete();
        }
        this.logger.info("Downloading plugin update...");
        String releaseUrl = "https://api.github.com/repos/elian1203/ezAuctions/releases/tags/" + this.latestSupportedPluginVersion;
        HttpRequest request = HttpRequest.newBuilder(URI.create(releaseUrl)).build();
        String releaseJson = (String)((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).get();
        JsonObject releaseObject = JsonParser.parseString((String)releaseJson).getAsJsonObject();
        JsonArray releaseAssets = releaseObject.getAsJsonArray("assets");
        JsonObject jarAsset = null;
        for (JsonElement assetElement : releaseAssets) {
            JsonObject assetObject = assetElement.getAsJsonObject();
            String name = assetObject.get("name").getAsString().toLowerCase();
            if (!name.contains("ezauctions") || !name.endsWith(".jar")) continue;
            jarAsset = assetObject;
            break;
        }
        if (jarAsset == null) {
            this.logger.warning("Could not find release asset to download!");
            return;
        }
        String downloadUrl = jarAsset.get("url").getAsString();
        Path downloadPath = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "ezAuctions_" + this.latestSupportedPluginVersion + ".jar");
        request = HttpRequest.newBuilder(URI.create(downloadUrl)).header("Accept", "application/octet-stream").build();
        HttpResponse<InputStream> downloadResponse = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).join();
        if (downloadResponse.statusCode() >= 200 && downloadResponse.statusCode() < 300) {
            try {
                Files.copy(downloadResponse.body(), downloadPath, StandardCopyOption.REPLACE_EXISTING);
                downloadedFilePath = downloadPath;
                this.logger.info("Finished downloading plugin update. Update will be applied when the server is shutdown.");
            }
            catch (IOException e) {
                this.logger.severe("Could not copy downloaded plugin update to file system!", e);
            }
        } else {
            this.logger.warning("Failed to download plugin update! " + downloadResponse.statusCode());
        }
    }

    private void moveDownloadedUpdateToPluginsDir() {
        if (shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        if (downloadedFilePath == null) {
            return;
        }
        shutdownHook = new Thread(() -> {
            Path newFilePath = Path.of(this.plugin.getDataFolder().getParentFile().getAbsolutePath(), downloadedFilePath.toFile().getName());
            try {
                Files.move(downloadedFilePath, newFilePath, StandardCopyOption.REPLACE_EXISTING);
                File existingJarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
                if (existingJarFile.exists()) {
                    existingJarFile.delete();
                }
            }
            catch (IOException e) {
                this.logger.severe("Could not move new jar file!", e);
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (p.hasPermission("ezauctions.updatemessage")) {
            this.messages.sendMessage((CommandSender)p, "login.updatemessage", Placeholder.unparsed("latestversion", this.latestSupportedPluginVersion), Placeholder.unparsed("serverversion", this.serverPluginVersion));
        }
    }
}

