/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.data;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import me.elian.ezauctions.Logger;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.data.Database;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.AuctionPlayerIgnore;
import me.elian.ezauctions.model.SavedItem;
import me.elian.ezauctions.ormlite.dao.Dao;
import me.elian.ezauctions.ormlite.dao.DaoManager;
import me.elian.ezauctions.ormlite.jdbc.JdbcPooledConnectionSource;
import me.elian.ezauctions.ormlite.support.ConnectionSource;
import me.elian.ezauctions.ormlite.table.TableUtils;
import me.elian.ezauctions.scheduler.TaskScheduler;
import org.jetbrains.annotations.NotNull;

@Singleton
public class OrmLiteDatabase
implements Database {
    private final Logger logger;
    private final TaskScheduler scheduler;
    private final ConfigController config;
    private final Object connectingMonitor = new Object();
    private boolean connecting;
    private ConnectionSource connectionSource;
    private Dao<AuctionPlayer, UUID> auctionPlayerDao;

    @Inject
    public OrmLiteDatabase(Logger logger, ConfigController config, TaskScheduler scheduler) {
        this.logger = logger;
        this.config = config;
        this.scheduler = scheduler;
        scheduler.runAsyncTask(() -> {
            try {
                this.reconnect();
            }
            catch (Exception e) {
                logger.severe("Could not connect to database! Check your connection string!", e);
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<AuctionPlayer> getAuctionPlayer(@NotNull UUID id) {
        CompletableFuture<AuctionPlayer> future = new CompletableFuture<AuctionPlayer>();
        this.scheduler.runAsyncTask(() -> {
            if (this.connectionSource != null) {
                try {
                    AuctionPlayer auctionPlayer = this.auctionPlayerDao.queryForId(id);
                    if (auctionPlayer == null) {
                        auctionPlayer = new AuctionPlayer(id);
                        this.auctionPlayerDao.create(auctionPlayer);
                        auctionPlayer = this.auctionPlayerDao.queryForId(id);
                    }
                    future.complete(auctionPlayer);
                    return;
                }
                catch (Exception e) {
                    this.logger.severe("Could not get auction player!", e);
                    future.complete(new AuctionPlayer(id));
                    return;
                }
            }
            if (this.connecting) {
                try {
                    Object e = this.connectingMonitor;
                    synchronized (e) {
                        if (this.connecting) {
                            this.connectingMonitor.wait();
                        }
                    }
                    future.complete(this.getAuctionPlayer(id).get());
                }
                catch (InterruptedException | ExecutionException e) {
                    this.logger.severe("Exception when waiting for database connection", e);
                }
            } else {
                this.logger.severe("Could not get auction player due to database connection failure!");
            }
            future.complete(new AuctionPlayer(id));
        });
        return future;
    }

    @Override
    public void saveAuctionPlayer(@NotNull AuctionPlayer ap) {
        this.scheduler.runAsyncTask(() -> {
            if (this.connectionSource != null) {
                try {
                    this.auctionPlayerDao.createOrUpdate(ap);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.connecting) {
                try {
                    Object e = this.connectingMonitor;
                    synchronized (e) {
                        if (this.connecting) {
                            this.connectingMonitor.wait();
                        }
                    }
                    this.saveAuctionPlayer(ap);
                }
                catch (InterruptedException e) {
                    this.logger.severe("Could not wait");
                }
            } else {
                this.logger.severe("Could not get auction player due to database connection failure!");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws SQLException {
        Object object = this.connectingMonitor;
        synchronized (object) {
            this.connecting = true;
            if (this.connectionSource != null) {
                ConnectionSource connectionSourceTemp = this.connectionSource;
                this.connectionSource = null;
                try {
                    connectionSourceTemp.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                String connectionString = this.config.getConfig().getString("data.connection-string");
                String user = this.config.getConfig().getString("data.username");
                if (user != null && !user.isBlank()) {
                    String pass = this.config.getConfig().getString("data.password");
                    this.connectionSource = new JdbcPooledConnectionSource(connectionString, user, pass);
                } else {
                    this.connectionSource = new JdbcPooledConnectionSource(connectionString);
                }
                this.auctionPlayerDao = DaoManager.createDao(this.connectionSource, AuctionPlayer.class);
                try {
                    this.auctionPlayerDao.queryForId(UUID.randomUUID());
                }
                catch (SQLException e) {
                    TableUtils.createTableIfNotExists(this.connectionSource, AuctionPlayer.class);
                    TableUtils.createTableIfNotExists(this.connectionSource, AuctionPlayerIgnore.class);
                    TableUtils.createTableIfNotExists(this.connectionSource, SavedItem.class);
                }
                this.connectingMonitor.notifyAll();
            }
            catch (Exception e) {
                this.connecting = false;
                this.connectingMonitor.notifyAll();
                throw e;
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.connectionSource != null) {
            try {
                this.connectionSource.close();
                this.connectionSource = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

