/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.HoverEvent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    private static Optional<Boolean> hasAsHoverEvent = Optional.empty();
    private static Optional<Boolean> hasItemMetaAsString = Optional.empty();

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(@NotNull ItemStack item) throws IllegalStateException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)item);
                dataOutput.flush();
                byArray = Base64.getEncoder().encode(outputStream.toByteArray());
            }
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ItemStack deserialize(byte[] data) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));){
            ItemStack itemStack;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                itemStack = (ItemStack)dataInput.readObject();
            }
            return itemStack;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }

    public static boolean addItemToPlayerInventory(@NotNull Player player, @NotNull ItemStack itemStack, int amount) {
        ItemStack clone;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int maxStackSize = itemStack.getMaxStackSize();
        while (amount > maxStackSize) {
            clone = itemStack.clone();
            clone.setAmount(maxStackSize);
            items.add(clone);
            amount -= maxStackSize;
        }
        if (amount != 0) {
            clone = itemStack.clone();
            clone.setAmount(amount);
            items.add(clone);
        }
        ItemStack[] array = new ItemStack[items.size()];
        array = items.toArray(array);
        HashMap leftover = player.getInventory().addItem(array);
        if (leftover.isEmpty()) {
            return false;
        }
        Location location = player.getLocation();
        World world = player.getWorld();
        for (ItemStack item : leftover.values()) {
            world.dropItem(location, item);
        }
        return true;
    }

    public static void removeItemFromPlayerInventory(@NotNull Player player, @NotNull ItemStack itemStack, int amount) {
        int remainingAmount = amount;
        PlayerInventory inventory = player.getInventory();
        ItemStack mainHand = inventory.getItemInMainHand();
        if (mainHand.isSimilar(itemStack)) {
            int itemAmount = mainHand.getAmount();
            if (itemAmount <= remainingAmount) {
                inventory.setItemInMainHand(null);
                remainingAmount -= itemAmount;
            } else {
                mainHand.setAmount(itemAmount - remainingAmount);
                inventory.setItemInMainHand(mainHand);
                return;
            }
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack is = inventory.getItem(i);
            if (is == null || !itemStack.isSimilar(is)) continue;
            if (is.getAmount() > remainingAmount) {
                is.setAmount(is.getAmount() - remainingAmount);
                inventory.setItem(i, is);
                break;
            }
            inventory.setItem(i, null);
            if ((remainingAmount -= is.getAmount()) == 0) break;
        }
    }

    public static int getAmountOfItemInInventory(@NotNull Player player, @NotNull ItemStack itemStack) {
        int amountInInventory = 0;
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack is = inventory.getItem(i);
            if (is == null || !itemStack.isSimilar(is)) continue;
            amountInInventory += is.getAmount();
        }
        return amountInInventory;
    }

    private static boolean hasAsHoverEventMethod() {
        if (hasAsHoverEvent.isPresent()) {
            return hasAsHoverEvent.get();
        }
        Boolean methodExists = Boolean.FALSE;
        try {
            ItemStack.class.getMethod("asHoverEvent", UnaryOperator.class);
            methodExists = Boolean.TRUE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        hasAsHoverEvent = Optional.of(methodExists);
        return methodExists;
    }

    @Nullable
    public static HoverEvent<HoverEvent.ShowItem> getItemHover(@NotNull ItemStack itemStack, UnaryOperator<HoverEvent.ShowItem> transform) {
        if (ItemHelper.hasAsHoverEventMethod()) {
            return itemStack.asHoverEvent(transform);
        }
        String itemNBT = null;
        try {
            itemNBT = ItemHelper.getItemNBT(itemStack).replace("minecraft:", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (itemNBT == null) {
            return null;
        }
        NamespacedKey typeKey = itemStack.getType().getKey();
        Key itemKey = Key.key(typeKey.getNamespace(), typeKey.getKey());
        return HoverEvent.showItem(itemKey, itemStack.getAmount(), BinaryTagHolder.binaryTagHolder(itemNBT)).asHoverEvent(transform);
    }

    private static boolean hasItemMetaGetAsStringMethod() {
        if (hasItemMetaAsString.isPresent()) {
            return hasItemMetaAsString.get();
        }
        Boolean methodExists = Boolean.FALSE;
        try {
            ItemMeta.class.getMethod("getAsString", new Class[0]);
            methodExists = Boolean.TRUE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        hasItemMetaAsString = Optional.of(methodExists);
        return methodExists;
    }

    @NotNull
    public static String getItemNBT(@NotNull ItemStack itemStack) throws Exception {
        if (ItemHelper.hasItemMetaGetAsStringMethod()) {
            return itemStack.hasItemMeta() ? itemStack.getItemMeta().getAsString() : "{}";
        }
        return ItemHelper.getItemNbtNms(itemStack);
    }

    @NotNull
    private static String getItemNbtNms(@NotNull ItemStack itemStack) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Class<?> itemStackClass = itemStack.getClass();
        Class<?> nbtTagCompoundClass = Class.forName("net.minecraft.nbt.NBTTagCompound");
        Object nmsStack = itemStackClass.getMethod("asNMSCopy", ItemStack.class).invoke(null, itemStack);
        Method getNbtMethod = null;
        for (Method method : nmsStack.getClass().getMethods()) {
            if (!method.getReturnType().equals(nbtTagCompoundClass) || method.getParameterCount() != 0) continue;
            getNbtMethod = method;
            break;
        }
        if (getNbtMethod == null) {
            throw new NoSuchMethodException("Could not save item to nbt! getNbtMethod not found!");
        }
        Object tag = getNbtMethod.invoke(nmsStack, new Object[0]);
        if (tag == null) {
            tag = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return tag.toString();
    }

    @NotNull
    public static String getMinecraftName(ItemStack is) {
        Material material = is.getType();
        return (material.isBlock() ? "block" : "item") + ".minecraft." + material.toString().toLowerCase();
    }

    public static int getXPForRepair(ItemStack is) {
        int cost = is.getItemMeta().serialize().getOrDefault("repair-cost", 0);
        boolean repairable = cost <= 40;
        return repairable ? cost : -1;
    }
}

