/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.model;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import me.elian.ezauctions.controller.AuctionPlayerController;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.controller.ScoreboardController;
import me.elian.ezauctions.event.AuctionEndEvent;
import me.elian.ezauctions.event.AuctionStartEvent;
import me.elian.ezauctions.model.AuctionData;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.Bid;
import me.elian.ezauctions.model.BidList;
import me.elian.ezauctions.scheduler.CancellableTask;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Auction
implements Runnable {
    private final Plugin plugin;
    private final TaskScheduler scheduler;
    private final Economy economy;
    private final Permission permission;
    private final AuctionPlayerController playerController;
    private final ConfigController config;
    private final MessageController messages;
    private final ScoreboardController scoreboard;
    private final List<Integer> broadcastTimes;
    private AuctionData auctionData;
    private BidList bidList;
    private Runnable completedRunnable;
    private CancellableTask repeatingTask;
    private boolean started;
    private boolean running;
    private int autoCancelTime;
    private int remainingSeconds;
    private int antiSnipeRunTimes;

    @Inject
    public Auction(Plugin plugin, TaskScheduler scheduler, Economy economy, Permission permission, AuctionPlayerController playerController, ConfigController config, MessageController messages, ScoreboardController scoreboard) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.economy = economy;
        this.permission = permission;
        this.playerController = playerController;
        this.config = config;
        this.messages = messages;
        this.scoreboard = scoreboard;
        this.broadcastTimes = config.getConfig().getIntegerList("auctions.broadcast-times");
    }

    public AuctionData getAuctionData() {
        return this.auctionData;
    }

    public BidList getBidList() {
        return this.bidList;
    }

    public int getRemainingSeconds() {
        return this.remainingSeconds;
    }

    public boolean isCompleted() {
        return !this.running;
    }

    public void startAuction(@NotNull AuctionData auctionData, @NotNull Runnable completedRunnable) {
        if (this.started) {
            throw new IllegalStateException("Can not start an auction that has already been started!");
        }
        this.started = true;
        this.running = true;
        this.auctionData = auctionData;
        this.completedRunnable = completedRunnable;
        AuctionStartEvent event = new AuctionStartEvent(this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            completedRunnable.run();
            return;
        }
        this.autoCancelTime = this.config.getConfig().getInt("auctions.auto-cancel-no-bids", 0);
        this.loadAuctionData(auctionData);
        this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, false, "auction.info", new TagResolver[0]);
        this.scoreboard.createForAuction(this, this.playerController.getOnlinePlayers());
        this.repeatingTask = this.scheduler.runAsyncRepeatingTask(this.plugin, this, 1L, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAuction(boolean returnMoney) {
        Auction auction = this;
        synchronized (auction) {
            if (!this.running) {
                return;
            }
            this.cancelRepeatingTask();
            this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, false, "auction.cancelled", new TagResolver[0]);
            this.auctionData.giveItemToPlayer(this.auctionData.getAuctioneer(), this.playerController, this.scheduler, this.config, this.messages);
            if (returnMoney) {
                this.returnStartPriceToAuctioneer();
            }
            this.returnBidderMoney(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAuctionShutdown() {
        Auction auction = this;
        synchronized (auction) {
            if (!this.running) {
                return;
            }
            this.cancelRepeatingTask();
            this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, false, "auction.cancelled", new TagResolver[0]);
            this.auctionData.addSavedItemToPlayer(this.auctionData.getAuctioneer(), this.playerController, this.scheduler);
            this.returnStartPriceToAuctioneer();
            this.returnBidderMoney(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void impoundAuction(@NotNull AuctionPlayer impoundingPlayer) {
        Auction auction = this;
        synchronized (auction) {
            if (!this.running) {
                return;
            }
            this.cancelRepeatingTask();
            String impoundingPlayerName = impoundingPlayer.getOfflinePlayer().getName();
            if (impoundingPlayerName == null) {
                impoundingPlayerName = "";
            }
            this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, false, "auction.impounded", Placeholder.unparsed("impoundingplayer", impoundingPlayerName));
            this.auctionData.giveItemToPlayer(impoundingPlayer, this.playerController, this.scheduler, this.config, this.messages);
            this.returnStartPriceToAuctioneer();
            this.returnBidderMoney(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        Auction auction = this;
        synchronized (auction) {
            if (!this.running) {
                return;
            }
            this.cancelRepeatingTask();
            this.handleAuctionTimeCompleted();
        }
    }

    public void checkAntiSnipe() {
        if (!this.running) {
            return;
        }
        if (!this.config.getConfig().getBoolean("antisnipe.enabled")) {
            return;
        }
        if (this.antiSnipeRunTimes >= this.config.getConfig().getInt("antisnipe.run-times")) {
            return;
        }
        if (this.remainingSeconds > this.config.getConfig().getInt("antisnipe.seconds-for-start")) {
            return;
        }
        ++this.antiSnipeRunTimes;
        this.remainingSeconds += this.config.getConfig().getInt("antisnipe.time");
        this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, true, "auction.antisnipe", new TagResolver[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Auction auction = this;
        synchronized (auction) {
            if (!this.running) {
                return;
            }
            --this.remainingSeconds;
            if (this.autoCancelTime != 0 && this.auctionData.getStartingAuctionTime() - this.remainingSeconds >= this.autoCancelTime && this.bidList.hasNoBids()) {
                this.cancelAuction(false);
            }
            this.scoreboard.updateForAuction(this);
            if (this.remainingSeconds == 0) {
                this.cancelRepeatingTask();
                this.handleAuctionTimeCompleted();
                return;
            }
            if (this.broadcastTimes.contains(this.remainingSeconds)) {
                this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, false, "auction.time_left", new TagResolver[0]);
            }
        }
    }

    private void cancelRepeatingTask() {
        this.running = false;
        if (this.repeatingTask != null) {
            this.repeatingTask.cancel();
        }
        this.scoreboard.remove();
        this.completedRunnable.run();
    }

    private void loadAuctionData(AuctionData auctionData) {
        this.remainingSeconds = auctionData.getStartingAuctionTime();
        this.bidList = new BidList(this);
    }

    private void handleAuctionTimeCompleted() {
        Bid winningBid = this.bidList.getHighestBid();
        if (winningBid == null) {
            this.auctionData.giveItemToPlayer(this.auctionData.getAuctioneer(), this.playerController, this.scheduler, this.config, this.messages);
            this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, false, "auction.finish.no_bids", new TagResolver[0]);
            this.messages.sendAuctionMessage((CommandSender)this.auctionData.getAuctioneer().getOnlinePlayer(), "reward.returned", this, new TagResolver[0]);
            return;
        }
        this.messages.broadcastAuctionMessage(this.playerController.getOnlinePlayers(), this, false, "auction.finish", new TagResolver[0]);
        if (this.auctionData.giveItemToPlayer(winningBid.auctionPlayer(), this.playerController, this.scheduler, this.config, this.messages)) {
            this.messages.sendAuctionMessage((CommandSender)winningBid.auctionPlayer().getOnlinePlayer(), "reward.received", this, new TagResolver[0]);
        }
        OfflinePlayer offlinePlayer = this.auctionData.getAuctioneer().getOfflinePlayer();
        double payout = winningBid.amount();
        double taxPercentage = 0.0;
        if (!this.isTaxExempt(offlinePlayer)) {
            taxPercentage = this.config.getConfig().getDouble("auctions.fees.tax-percent");
        }
        double payoutPercentage = (100.0 - taxPercentage) / 100.0;
        this.economy.depositPlayer(offlinePlayer, payout *= payoutPercentage);
        this.messages.sendAuctionMessage((CommandSender)offlinePlayer.getPlayer(), "reward.money_given", this, Formatter.number("payout", payout), Formatter.number("taxpercentage", taxPercentage));
        this.returnBidderMoney(false);
        AuctionEndEvent event = new AuctionEndEvent(this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
    }

    private boolean isTaxExempt(OfflinePlayer offlinePlayer) {
        if (this.permission == null) {
            return offlinePlayer.getPlayer() != null && offlinePlayer.getPlayer().hasPermission("ezauctions.taxexempt");
        }
        return this.permission.playerHas(this.auctionData.getWorld(), offlinePlayer, "ezauctions.taxexempt");
    }

    private void returnStartPriceToAuctioneer() {
        double startPrice = this.config.getConfig().getDouble("auction.fees.start-price");
        if (startPrice != 0.0) {
            this.economy.depositPlayer(this.auctionData.getAuctioneer().getOfflinePlayer(), startPrice);
        }
    }

    private void returnBidderMoney(boolean returnToHighestBidder) {
        Map<AuctionPlayer, Double> bidMap = this.bidList.getBidMap();
        if (bidMap.isEmpty()) {
            return;
        }
        if (!returnToHighestBidder) {
            bidMap.remove(this.bidList.getHighestBid().auctionPlayer());
        }
        for (Map.Entry<AuctionPlayer, Double> entry : bidMap.entrySet()) {
            this.economy.depositPlayer(entry.getKey().getOfflinePlayer(), entry.getValue().doubleValue());
        }
    }
}

