/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.model;

import me.elian.ezauctions.Logger;
import me.elian.ezauctions.controller.AuctionPlayerController;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.controller.MessageController;
import me.elian.ezauctions.helper.ItemHelper;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.SavedItem;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public final class AuctionData {
    private final AuctionPlayer auctioneer;
    private final ItemStack item;
    private final String amountString;
    private final boolean isSealed;
    private final String world;
    private double startingPrice;
    private int startingAuctionTime;
    private double incrementPrice;
    private double autoBuyPrice;
    private int amount;
    private String skullOwner;
    private int repairPrice;
    private String minecraftName;
    private String customName;
    private Key itemKey;

    public AuctionData(AuctionPlayer auctioneer, ItemStack item, String amountString, int startingAuctionTime, double startingPrice, double incrementPrice, double autoBuyPrice, boolean isSealed, String world) {
        this.auctioneer = auctioneer;
        this.item = item;
        this.amountString = amountString == null ? "" : amountString.toLowerCase();
        this.startingAuctionTime = startingAuctionTime;
        this.startingPrice = startingPrice;
        this.incrementPrice = incrementPrice;
        this.autoBuyPrice = autoBuyPrice;
        this.isSealed = isSealed;
        this.world = world;
    }

    public AuctionPlayer getAuctioneer() {
        return this.auctioneer;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getStartingAuctionTime() {
        return this.startingAuctionTime;
    }

    public double getStartingPrice() {
        return this.startingPrice;
    }

    public double getIncrementPrice() {
        return this.incrementPrice;
    }

    public double getAutoBuyPrice() {
        return this.autoBuyPrice;
    }

    public boolean isSealed() {
        return this.isSealed;
    }

    public String getWorld() {
        return this.world;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public int getRepairPrice() {
        return this.repairPrice;
    }

    public String getMinecraftName() {
        return this.minecraftName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public Key getItemKey() {
        return this.itemKey;
    }

    public void gatherAdditionalData(Logger logger) {
        if (this.item == null || this.item.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)meta;
            this.skullOwner = skullMeta.getOwner();
        }
        if (this.skullOwner == null) {
            this.skullOwner = "";
        }
        this.repairPrice = ItemHelper.getXPForRepair(this.item);
        NamespacedKey typeKey = this.item.getType().getKey();
        this.itemKey = Key.key(typeKey.getNamespace(), typeKey.getKey());
        this.customName = this.minecraftName = ItemHelper.getMinecraftName(this.item);
        if (meta != null && !meta.getDisplayName().isBlank()) {
            TextComponent legacySection = LegacyComponentSerializer.legacySection().deserialize(meta.getDisplayName());
            this.customName = (String)MiniMessage.miniMessage().serialize(legacySection);
        }
    }

    public void fillDefaults(@NotNull ConfigController configController) {
        FileConfiguration config = configController.getConfig();
        if (this.startingAuctionTime == 0) {
            this.startingAuctionTime = config.getInt("auctions.default.auction-time");
        }
        if (this.incrementPrice == 0.0) {
            this.incrementPrice = config.getInt("auctions.default.increment");
        }
    }

    public boolean validate(@NotNull ConfigController configController, @NotNull MessageController messages, Player player) {
        FileConfiguration config = configController.getConfig();
        this.truncateDecimals(config);
        return this.validateGameMode(config, messages, player) && this.validateWorld(config, messages, player) && this.validateType(config, messages, player) && this.findAmount(messages, player) && this.validateDamage(config, messages, player) && this.validateStartingPrice(config, messages, player) && this.validateIncrement(config, messages, player) && this.validateAutoBuy(config, messages, player) && this.validateTime(config, messages, player);
    }

    private void truncateDecimals(FileConfiguration config) {
        this.startingPrice = this.truncateToDecimalPlace(this.startingPrice, config.getInt("auctions.decimal.starting-price"));
        this.incrementPrice = this.truncateToDecimalPlace(this.incrementPrice, config.getInt("auctions.decimal.increment"));
        this.autoBuyPrice = this.truncateToDecimalPlace(this.autoBuyPrice, config.getInt("auctions.decimal.autobuy"));
    }

    private double truncateToDecimalPlace(double number, int decimalPlaces) {
        double pow = Math.pow(10.0, decimalPlaces);
        return (double)Math.round(number * pow) / pow;
    }

    private boolean validateStartingPrice(FileConfiguration config, MessageController messages, Player player) {
        double min2 = config.getDouble("auctions.minimum.starting-price");
        double max = config.getDouble("auctions.maximum.starting-price");
        if (this.startingPrice <= 0.0 || this.startingPrice < min2) {
            messages.sendMessage((CommandSender)player, "command.auction.start.invalid_start_price.min", Formatter.number("min", min2), Formatter.number("max", max), Formatter.number("entered", this.startingPrice));
            return false;
        }
        if (this.startingPrice > max && max != 0.0) {
            messages.sendMessage((CommandSender)player, "command.auction.start.invalid_start_price.max", Formatter.number("min", min2), Formatter.number("max", max), Formatter.number("entered", this.startingPrice));
            return false;
        }
        return true;
    }

    private boolean validateIncrement(FileConfiguration config, MessageController messages, Player player) {
        double min2 = config.getDouble("auctions.minimum.increment");
        double max = config.getDouble("auctions.maximum.increment");
        if (min2 == -1.0 && max == -1.0) {
            this.incrementPrice = config.getDouble("auctions.default.increment");
            return true;
        }
        if (this.incrementPrice <= 0.0 || this.incrementPrice < min2 || this.incrementPrice > max && max != 0.0) {
            messages.sendMessage((CommandSender)player, "command.auction.start.invalid-inc", Formatter.number("min", min2), Formatter.number("max", max), Formatter.number("entered", this.incrementPrice));
            return false;
        }
        return true;
    }

    private boolean validateAutoBuy(FileConfiguration config, MessageController messages, Player player) {
        double min2 = config.getDouble("auctions.minimum.autobuy");
        double max = config.getDouble("auctions.maximum.autobuy");
        if (min2 == -1.0 && max == -1.0) {
            this.autoBuyPrice = config.getDouble("auctions.default.autobuy");
            return true;
        }
        if (this.startingPrice > min2 && this.autoBuyPrice != 0.0) {
            min2 = this.startingPrice;
        }
        if (this.autoBuyPrice < 0.0 || this.autoBuyPrice < min2 || this.autoBuyPrice > max && max != 0.0) {
            messages.sendMessage((CommandSender)player, "command.auction.start.invalid-buyout", Formatter.number("min", min2), Formatter.number("max", max), Formatter.number("entered", this.autoBuyPrice));
            return false;
        }
        return true;
    }

    private boolean validateTime(FileConfiguration config, MessageController messages, Player player) {
        double min2 = config.getDouble("auctions.minimum.auction-time");
        double max = config.getDouble("auctions.maximum.auction-time");
        if (min2 == -1.0 && max == -1.0) {
            this.startingAuctionTime = config.getInt("auctions.default.auction-time");
            return true;
        }
        if (this.startingAuctionTime <= 0 || (double)this.startingAuctionTime < min2 || (double)this.startingAuctionTime > max && max != 0.0) {
            messages.sendMessage((CommandSender)player, "command.auction.start.invalid-time", Formatter.number("min", min2), Formatter.number("max", max), Formatter.number("entered", this.startingAuctionTime));
            return false;
        }
        return true;
    }

    private boolean validateDamage(FileConfiguration config, MessageController messages, Player player) {
        Damageable damageable;
        ItemMeta meta = this.item.getItemMeta();
        if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage() && config.getBoolean("auctions.toggles.restrict-damaged")) {
            messages.sendMessage((CommandSender)player, "command.auction.start.damaged_item", new TagResolver[0]);
            return false;
        }
        return true;
    }

    private boolean validateGameMode(FileConfiguration config, MessageController messages, Player player) {
        if (player.getGameMode() == GameMode.CREATIVE && config.getBoolean("auctions.toggles.deny-creative")) {
            messages.sendMessage((CommandSender)player, "command.auction.start.deny-creative", new TagResolver[0]);
            return false;
        }
        return true;
    }

    private boolean validateWorld(FileConfiguration config, MessageController messages, Player player) {
        if (config.getStringList("auctions.blocked-worlds").stream().anyMatch(blocked -> blocked.equalsIgnoreCase(player.getWorld().getName()))) {
            messages.sendMessage((CommandSender)player, "command.auction.start.blocked-worlds", new TagResolver[0]);
            return false;
        }
        return true;
    }

    private boolean validateType(FileConfiguration config, MessageController messages, Player player) {
        if (this.item.getType() == Material.AIR) {
            messages.sendMessage((CommandSender)player, "command.auction.start.cannot_auction_air", new TagResolver[0]);
            return false;
        }
        String typeString = this.item.getType().toString();
        if (config.getStringList("auctions.blocked-materials").stream().anyMatch(blocked -> blocked.equalsIgnoreCase(typeString))) {
            messages.sendMessage((CommandSender)player, "command.auction.start.blocked-materials", new TagResolver[0]);
            return false;
        }
        return true;
    }

    private boolean findAmount(MessageController messages, Player player) {
        if (this.amountString.equals("h") || this.amountString.equals("hand")) {
            this.amount = this.item.getAmount();
        } else if (this.amountString.equals("a") || this.amountString.equals("all")) {
            this.amount = ItemHelper.getAmountOfItemInInventory(player, this.item);
        } else {
            try {
                this.amount = Integer.parseInt(this.amountString);
                double amountInInventory = ItemHelper.getAmountOfItemInInventory(player, this.item);
                if (this.amount <= 0 || (double)this.amount > amountInInventory) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception e) {
                messages.sendMessage((CommandSender)player, "command.auction.start.invalid-amt", new TagResolver[0]);
                return false;
            }
        }
        return true;
    }

    public boolean giveItemToPlayer(AuctionPlayer auctionPlayer, AuctionPlayerController playerController, TaskScheduler scheduler, ConfigController config, MessageController messages) {
        Player player = auctionPlayer.getOnlinePlayer();
        if (player == null) {
            this.addSavedItemToPlayer(auctionPlayer, playerController, scheduler);
            return false;
        }
        if (config.getConfig().getBoolean("auctions.per-world-auctions") && !player.getWorld().getName().equals(this.world)) {
            messages.sendMessage((CommandSender)player, "reward.wrong_world", Placeholder.unparsed("itemworld", this.world));
            this.addSavedItemToPlayer(auctionPlayer, playerController, scheduler);
            return false;
        }
        if (config.getConfig().getStringList("auctions.blocked-worlds").contains(player.getWorld().getName())) {
            messages.sendMessage((CommandSender)player, "reward.blocked_world", new TagResolver[0]);
            this.addSavedItemToPlayer(auctionPlayer, playerController, scheduler);
            return false;
        }
        scheduler.runPlayerRegionTask(() -> {
            boolean overflow = ItemHelper.addItemToPlayerInventory(player, this.item, this.amount);
            if (overflow) {
                messages.sendMessage((CommandSender)player, "reward.full_inventory", new TagResolver[0]);
            }
        }, player);
        return true;
    }

    public void addSavedItemToPlayer(AuctionPlayer auctionPlayer, AuctionPlayerController playerController, TaskScheduler scheduler) {
        scheduler.runAsyncTask(() -> playerController.getPlayerFromDatabase(auctionPlayer.getUniqueId()).thenAccept(newAuctionPlayer -> {
            SavedItem savedItem = new SavedItem((AuctionPlayer)newAuctionPlayer, this.item, this.amount, this.world);
            newAuctionPlayer.getSavedItems().add(savedItem);
        }));
    }
}

