/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.model;

import java.util.Collection;
import java.util.UUID;
import me.elian.ezauctions.controller.ConfigController;
import me.elian.ezauctions.model.AuctionPlayerIgnore;
import me.elian.ezauctions.model.SavedItem;
import me.elian.ezauctions.ormlite.dao.ForeignCollection;
import me.elian.ezauctions.ormlite.field.DatabaseField;
import me.elian.ezauctions.ormlite.field.ForeignCollectionField;
import me.elian.ezauctions.ormlite.table.DatabaseTable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DatabaseTable(tableName="ezAuctions_AuctionPlayer")
public class AuctionPlayer {
    @DatabaseField(id=true)
    private UUID uniqueId;
    @DatabaseField
    private boolean ignoringSpammy;
    @DatabaseField
    private boolean ignoringAll;
    @DatabaseField
    private boolean ignoringScoreboard;
    @ForeignCollectionField(eager=true)
    private ForeignCollection<AuctionPlayerIgnore> ignoredPlayers;
    @ForeignCollectionField(eager=true)
    private ForeignCollection<SavedItem> savedItems;

    public AuctionPlayer() {
    }

    public AuctionPlayer(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Nullable
    public Player getOnlinePlayer() {
        return Bukkit.getPlayer((UUID)this.uniqueId);
    }

    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uniqueId);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public boolean isIgnoringSpammy() {
        return this.ignoringSpammy;
    }

    public void setIgnoringSpammy(boolean ignoringSpammy) {
        this.ignoringSpammy = ignoringSpammy;
    }

    public boolean isIgnoringAll() {
        return this.ignoringAll;
    }

    public void setIgnoringAll(boolean ignoringAll) {
        this.ignoringAll = ignoringAll;
    }

    public boolean isIgnoringScoreboard() {
        return this.ignoringScoreboard;
    }

    public void setIgnoringScoreboard(boolean ignoringScoreboard) {
        this.ignoringScoreboard = ignoringScoreboard;
    }

    public Collection<AuctionPlayerIgnore> getIgnoredPlayers() {
        return this.ignoredPlayers;
    }

    public Collection<SavedItem> getSavedItems() {
        return this.savedItems;
    }

    public boolean withinBoundary(ConfigController configController) {
        FileConfiguration config = configController.getConfig();
        if (!config.getBoolean("boundary.enabled", false)) {
            return true;
        }
        Player player = this.getOnlinePlayer();
        if (player == null) {
            return false;
        }
        Location playerLocation = player.getLocation();
        String world = config.getString("boundary.world");
        if (!player.getLocation().getWorld().getName().equalsIgnoreCase(world)) {
            return false;
        }
        double playerX = playerLocation.getX();
        double playerY = playerLocation.getY();
        double playerZ = playerLocation.getZ();
        double corner1X = config.getDouble("boundary.corner1.x");
        double corner1Y = config.getDouble("boundary.corner1.y");
        double corner1Z = config.getDouble("boundary.corner1.z");
        double corner2X = config.getDouble("boundary.corner2.x");
        double corner2Y = config.getDouble("boundary.corner2.y");
        double corner2Z = config.getDouble("boundary.corner2.z");
        return this.valueWithinRange(playerX, corner1X, corner2X) && this.valueWithinRange(playerY, corner1Y, corner2Y) && this.valueWithinRange(playerZ, corner1Z, corner2Z);
    }

    private boolean valueWithinRange(double bound1, double bound2, double value) {
        return value >= bound1 && value <= bound2 || value >= bound2 && value <= bound1;
    }
}

