/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.elian.ezauctions.model.Auction;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.model.Bid;

public class BidList {
    private final List<Bid> bids = new ArrayList<Bid>();
    private final Auction auction;
    private Bid highestBid;

    public BidList(Auction auction) {
        this.auction = auction;
    }

    public Bid getHighestBid() {
        return this.highestBid;
    }

    public boolean hasNoBids() {
        return this.bids.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withSync(Runnable runnable) {
        BidList bidList = this;
        synchronized (bidList) {
            runnable.run();
        }
    }

    public double getMinimumRequiredBid(AuctionPlayer auctionPlayer) {
        if (!this.auction.getAuctionData().isSealed()) {
            return this.bids.isEmpty() ? this.auction.getAuctionData().getStartingPrice() : this.highestBid.amount() + this.auction.getAuctionData().getIncrementPrice();
        }
        Bid highestBidForPlayer = this.getHighestBidForPlayer(auctionPlayer);
        return highestBidForPlayer == null ? this.auction.getAuctionData().getStartingPrice() : highestBidForPlayer.amount() + this.auction.getAuctionData().getIncrementPrice();
    }

    public Bid getHighestBidForPlayer(AuctionPlayer auctionPlayer) {
        Bid highestBidForPlayer = null;
        for (Bid bid : this.bids) {
            if (!bid.auctionPlayer().getUniqueId().equals(auctionPlayer.getUniqueId())) continue;
            if (highestBidForPlayer == null) {
                highestBidForPlayer = bid;
                continue;
            }
            if (!(highestBidForPlayer.amount() < bid.amount())) continue;
            highestBidForPlayer = bid;
        }
        return highestBidForPlayer;
    }

    public int getNumberOfBids(AuctionPlayer auctionPlayer) {
        int count = 0;
        for (Bid bid : this.bids) {
            if (!bid.auctionPlayer().getUniqueId().equals(auctionPlayer.getUniqueId())) continue;
            ++count;
        }
        return count;
    }

    public int getConsecutiveBids(AuctionPlayer auctionPlayer) {
        int bidIndex = this.bids.size() - 1;
        int consecutiveBids = 0;
        while (bidIndex >= 0 && this.bids.get(bidIndex).auctionPlayer().getUniqueId().equals(auctionPlayer.getUniqueId())) {
            --bidIndex;
            ++consecutiveBids;
        }
        return consecutiveBids;
    }

    public void placeBid(Bid bid) {
        double autoBuyPrice;
        this.bids.add(bid);
        if (this.highestBid == null || bid.amount() > this.highestBid.amount()) {
            this.highestBid = bid;
        }
        if ((autoBuyPrice = this.auction.getAuctionData().getAutoBuyPrice()) != 0.0 && bid.amount() >= autoBuyPrice) {
            this.auction.end();
        }
        this.auction.checkAntiSnipe();
    }

    public boolean playerHasAnyBids(UUID id) {
        for (Bid bid : this.bids) {
            if (!bid.auctionPlayer().getUniqueId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Map<AuctionPlayer, Double> getBidMap() {
        HashMap<AuctionPlayer, Double> map = new HashMap<AuctionPlayer, Double>();
        for (Bid bid : this.bids) {
            double current = map.getOrDefault(bid.auctionPlayer(), 0.0);
            if (!(bid.amount() > current)) continue;
            map.put(bid.auctionPlayer(), bid.amount());
        }
        return map;
    }
}

