/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.model;

import java.io.IOException;
import java.util.Base64;
import me.elian.ezauctions.helper.ItemHelper;
import me.elian.ezauctions.model.AuctionPlayer;
import me.elian.ezauctions.ormlite.field.DataType;
import me.elian.ezauctions.ormlite.field.DatabaseField;
import me.elian.ezauctions.ormlite.table.DatabaseTable;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@DatabaseTable(tableName="ezAuctions_SavedItem")
public class SavedItem {
    @DatabaseField(generatedId=true)
    private int id;
    @DatabaseField(foreign=true)
    private AuctionPlayer auctionPlayer;
    @DatabaseField(dataType=DataType.BYTE_ARRAY)
    private byte[] serializedItemBytes;
    @DatabaseField
    private int amount;
    @DatabaseField
    private String world;

    public SavedItem() {
    }

    public SavedItem(@NotNull AuctionPlayer auctionPlayer, @NotNull ItemStack itemStack, int amount, @NotNull String world) {
        this.auctionPlayer = auctionPlayer;
        this.serializedItemBytes = ItemHelper.serialize(itemStack);
        this.amount = amount;
        this.world = world;
    }

    @NotNull
    public String getSerializedItemJson() {
        return new String(Base64.getDecoder().decode(this.serializedItemBytes));
    }

    @NotNull
    public ItemStack getItemStack() throws IOException {
        return ItemHelper.deserialize(this.serializedItemBytes);
    }

    public int getAmount() {
        return this.amount;
    }

    @NotNull
    public String getWorld() {
        return this.world;
    }
}

