/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.db;

import java.util.List;
import me.elian.ezauctions.ormlite.db.BaseDatabaseType;
import me.elian.ezauctions.ormlite.field.DataPersister;
import me.elian.ezauctions.ormlite.field.FieldConverter;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.field.SqlType;
import me.elian.ezauctions.ormlite.field.converter.BooleanNumberFieldConverter;
import me.elian.ezauctions.ormlite.field.types.BigDecimalStringType;

public abstract class BaseSqliteDatabaseType
extends BaseDatabaseType {
    @Override
    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (fieldType.getSqlType() == SqlType.LONG && fieldType.isGeneratedId()) {
            sb.append("INTEGER");
        } else {
            sb.append("BIGINT");
        }
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        if (fieldType.getSqlType() != SqlType.INTEGER && fieldType.getSqlType() != SqlType.LONG) {
            throw new IllegalArgumentException("Sqlite requires that auto-increment generated-id be integer or long type");
        }
        sb.append("PRIMARY KEY AUTOINCREMENT ");
    }

    @Override
    protected boolean generatedIdSqlAtEnd() {
        return false;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return false;
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return false;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return true;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister, FieldType fieldType) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                return BooleanNumberFieldConverter.getSingleton();
            }
            case BIG_DECIMAL: {
                return BigDecimalStringType.getSingleton();
            }
        }
        return super.getFieldConverter(dataPersister, fieldType);
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("DEFAULT VALUES");
    }
}

