/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.field.types;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.field.SqlType;
import me.elian.ezauctions.ormlite.field.types.BaseDateType;
import me.elian.ezauctions.ormlite.field.types.DateStringFormatConfig;
import me.elian.ezauctions.ormlite.support.DatabaseResults;

public class DateType
extends BaseDateType {
    private static final DateType singleTon = new DateType();

    public static DateType getSingleton() {
        return singleTon;
    }

    private DateType() {
        super(SqlType.DATE, new Class[]{Date.class});
    }

    protected DateType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        DateStringFormatConfig dateFormatConfig = DateType.convertDateStringConfig(fieldType, this.getDefaultDateFormatConfig());
        try {
            return new Timestamp(DateType.parseDateString(dateFormatConfig, defaultStr).getTime());
        }
        catch (ParseException e) {
            throw new SQLException("Problems parsing default date string '" + defaultStr + "' using '" + dateFormatConfig + '\'', e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getTimestamp(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        Timestamp value = (Timestamp)sqlArg;
        return new Date(value.getTime());
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        Date date = (Date)javaObject;
        return new Timestamp(date.getTime());
    }

    @Override
    public boolean isArgumentHolderRequired() {
        return true;
    }
}

