/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.jdbc;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import me.elian.ezauctions.ormlite.dao.ObjectCache;
import me.elian.ezauctions.ormlite.misc.IOUtils;
import me.elian.ezauctions.ormlite.support.DatabaseResults;

public class JdbcDatabaseResults
implements DatabaseResults {
    private final PreparedStatement preparedStmt;
    private final ResultSet resultSet;
    private final ResultSetMetaData metaData;
    private final ObjectCache objectCache;
    private final boolean cacheStore;
    private boolean first = true;

    public JdbcDatabaseResults(PreparedStatement preparedStmt, ResultSet resultSet, ObjectCache objectCache, boolean cacheStore) throws SQLException {
        this.preparedStmt = preparedStmt;
        this.resultSet = resultSet;
        this.metaData = resultSet.getMetaData();
        this.objectCache = objectCache;
        this.cacheStore = cacheStore;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.metaData.getColumnCount();
    }

    @Override
    public String[] getColumnNames() throws SQLException {
        int colN = this.metaData.getColumnCount();
        String[] columnNames = new String[colN];
        for (int colC = 0; colC < colN; ++colC) {
            columnNames[colC] = this.metaData.getColumnLabel(colC + 1);
        }
        return columnNames;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.first) {
            this.first = false;
            return this.next();
        }
        return this.resultSet.first();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.resultSet.next()) {
            return true;
        }
        if (!this.preparedStmt.getMoreResults()) {
            return false;
        }
        return this.resultSet.next();
    }

    @Override
    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    @Override
    public boolean moveRelative(int offset) throws SQLException {
        return this.resultSet.relative(offset);
    }

    @Override
    public boolean moveAbsolute(int position) throws SQLException {
        return this.resultSet.absolute(position);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.resultSet.findColumn(columnName) - 1;
    }

    @Override
    public InputStream getBlobStream(int columnIndex) throws SQLException {
        Blob blob = this.resultSet.getBlob(columnIndex + 1);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex + 1);
    }

    @Override
    public char getChar(int columnIndex) throws SQLException {
        String string = this.resultSet.getString(columnIndex + 1);
        if (string == null || string.length() == 0) {
            return '\u0000';
        }
        if (string.length() == 1) {
            return string.charAt(0);
        }
        throw new SQLException("More than 1 character stored in database column: " + columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.resultSet.getByte(columnIndex + 1);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex + 1);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex + 1);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.resultSet.getFloat(columnIndex + 1);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex + 1);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex + 1);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.resultSet.getShort(columnIndex + 1);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex + 1);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex + 1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex + 1);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.resultSet.getObject(columnIndex + 1);
    }

    @Override
    public boolean wasNull(int columnIndex) throws SQLException {
        return this.resultSet.wasNull();
    }

    @Override
    public ObjectCache getObjectCacheForRetrieve() {
        return this.objectCache;
    }

    @Override
    public ObjectCache getObjectCacheForStore() {
        if (this.cacheStore) {
            return this.objectCache;
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            throw new SQLException("could not close result set", e);
        }
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

