/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.logger;

import me.elian.ezauctions.ormlite.logger.ConsoleLogBackend;
import me.elian.ezauctions.ormlite.logger.Level;
import me.elian.ezauctions.ormlite.logger.LocalLogBackend;
import me.elian.ezauctions.ormlite.logger.LogBackend;
import me.elian.ezauctions.ormlite.logger.LogBackendFactory;
import me.elian.ezauctions.ormlite.logger.NullLogBackend;

public enum LogBackendType implements LogBackendFactory
{
    SLF4J("me.elian.ezauctions.ormlite.logger.Slf4jLoggingLogBackend$Slf4jLoggingLogBackendFactory"),
    ANDROID("me.elian.ezauctions.ormlite.android.AndroidLogBackend$AndroidLogBackendFactory"),
    LOGBACK("me.elian.ezauctions.ormlite.logger.LogbackLogBackend$LogbackLogBackendFactory"),
    COMMONS_LOGGING("me.elian.ezauctions.ormlite.logger.CommonsLoggingLogBackend$CommonsLoggingLogBackendFactory"),
    LOG4J2("me.elian.ezauctions.ormlite.logger.Log4j2LogBackend$Log4j2LogBackendFactory"),
    LOG4J("me.elian.ezauctions.ormlite.logger.Log4jLogBackend$Log4jLogBackendFactory"),
    LOCAL(new LocalLogBackend.LocalLogBackendFactory()),
    CONSOLE(new ConsoleLogBackend.ConsoleLogBackendFactory()),
    JAVA_UTIL("me.elian.ezauctions.ormlite.logger.JavaUtilLogBackend$JavaUtilLogBackendFactory"),
    NULL(new NullLogBackend.NullLogBackendFactory());

    private final LogBackendFactory factory;

    private LogBackendType(LogBackendFactory factory) {
        this.factory = factory;
    }

    private LogBackendType(String logBackendFactoryClassName) {
        this.factory = this.detectFactory(logBackendFactoryClassName);
    }

    @Override
    public LogBackend createLogBackend(String classLabel) {
        return this.factory.createLogBackend(classLabel);
    }

    public boolean isAvailable() {
        return this == LOCAL || this != NULL && !(this.factory instanceof LocalLogBackend.LocalLogBackendFactory);
    }

    private LogBackendFactory detectFactory(String factoryClassName) {
        try {
            LogBackendFactory factory = (LogBackendFactory)Class.forName(factoryClassName).newInstance();
            factory.createLogBackend("test").isLevelEnabled(Level.INFO);
            return factory;
        }
        catch (Throwable th) {
            String queuedWarning = "Unable to create instance of class " + factoryClassName + " for log type " + this + ", using local log: " + th.getMessage();
            return new LocalLogBackend.LocalLogBackendFactory(queuedWarning);
        }
    }
}

