/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.misc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import me.elian.ezauctions.ormlite.logger.Logger;
import me.elian.ezauctions.ormlite.logger.LoggerFactory;
import me.elian.ezauctions.ormlite.misc.WrappedStatement;
import me.elian.ezauctions.ormlite.support.CompiledStatement;
import me.elian.ezauctions.ormlite.support.DatabaseConnection;

public class WrappedDatabaseConnection
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(WrappedDatabaseConnection.class);
    protected final DatabaseConnection connection;
    protected final DatabaseConnection connectionProxy;
    protected final List<WrappedStatement> wrappedStatements = new ArrayList<WrappedStatement>();

    public WrappedDatabaseConnection(DatabaseConnection connection) {
        this.connection = connection;
        this.connectionProxy = (DatabaseConnection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DatabaseConnection.class}, (InvocationHandler)this);
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.connection;
    }

    public DatabaseConnection getDatabaseConnectionProxy() {
        return this.connectionProxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        logger.trace("{}: running method on connection: {}", this, (Object)method.getName());
        try {
            Object result = method.invoke((Object)this.connection, args);
            if (method.getName().equals("compileStatement") && result instanceof CompiledStatement) {
                WrappedStatement wrappedStatement = new WrappedStatement((CompiledStatement)result);
                this.wrappedStatements.add(wrappedStatement);
                logger.trace("{}: connection is wrapping statement: {}", this, result);
                result = wrappedStatement.getStatementProxy();
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public boolean isAllStatementsClosed() {
        for (WrappedStatement wrappedStatement : this.wrappedStatements) {
            if (wrappedStatement.isClosed()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        this.wrappedStatements.clear();
    }
}

