/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.stmt.mapped;

import java.sql.SQLException;
import java.util.List;
import me.elian.ezauctions.ormlite.dao.Dao;
import me.elian.ezauctions.ormlite.db.DatabaseType;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.logger.Logger;
import me.elian.ezauctions.ormlite.logger.LoggerFactory;
import me.elian.ezauctions.ormlite.support.ConnectionSource;
import me.elian.ezauctions.ormlite.table.TableInfo;

public abstract class BaseMappedStatement<T, ID> {
    protected static Logger logger = LoggerFactory.getLogger(BaseMappedStatement.class);
    protected final Dao<T, ID> dao;
    protected final ConnectionSource connectionSource;
    protected final TableInfo<T, ID> tableInfo;
    protected final Class<T> clazz;
    protected final FieldType idField;
    protected final String statement;
    protected final FieldType[] argFieldTypes;

    protected BaseMappedStatement(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        this.dao = dao;
        this.connectionSource = dao.getConnectionSource();
        this.tableInfo = tableInfo;
        this.clazz = tableInfo.getDataClass();
        this.idField = tableInfo.getIdField();
        this.statement = statement;
        this.argFieldTypes = argFieldTypes;
    }

    protected Object[] getFieldObjects(Object data) throws SQLException {
        Object[] objects = new Object[this.argFieldTypes.length];
        for (int i = 0; i < this.argFieldTypes.length; ++i) {
            FieldType fieldType = this.argFieldTypes[i];
            objects[i] = fieldType.isAllowGeneratedIdInsert() ? fieldType.getFieldValueIfNotDefault(data) : fieldType.extractJavaFieldToSqlArgValue(data);
            if (objects[i] != null) continue;
            objects[i] = fieldType.getDefaultValue();
        }
        return objects;
    }

    protected Object convertIdToFieldObject(ID id) throws SQLException {
        return this.idField.convertJavaFieldToSqlArgValue(id);
    }

    static void appendWhereFieldEq(DatabaseType databaseType, FieldType fieldType, StringBuilder sb, List<FieldType> fieldTypeList) {
        sb.append("WHERE ");
        BaseMappedStatement.appendFieldColumnName(databaseType, sb, fieldType, fieldTypeList);
        sb.append("= ?");
    }

    static void appendTableName(DatabaseType databaseType, StringBuilder sb, String prefix, String tableName) {
        if (prefix != null) {
            sb.append(prefix);
        }
        databaseType.appendEscapedEntityName(sb, tableName);
        sb.append(' ');
    }

    static void appendTableName(DatabaseType databaseType, StringBuilder sb, String prefix, TableInfo<?, ?> tableInfo) {
        if (prefix != null) {
            sb.append(prefix);
        }
        if (tableInfo.getSchemaName() != null && tableInfo.getSchemaName().length() > 0) {
            databaseType.appendEscapedEntityName(sb, tableInfo.getSchemaName());
            sb.append('.');
        }
        databaseType.appendEscapedEntityName(sb, tableInfo.getTableName());
        sb.append(' ');
    }

    static void appendFieldColumnName(DatabaseType databaseType, StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        databaseType.appendEscapedEntityName(sb, fieldType.getColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
        sb.append(' ');
    }

    public String toString() {
        return this.statement;
    }
}

