/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.stmt.mapped;

import java.sql.SQLException;
import me.elian.ezauctions.ormlite.dao.Dao;
import me.elian.ezauctions.ormlite.dao.ObjectCache;
import me.elian.ezauctions.ormlite.db.DatabaseType;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.logger.Level;
import me.elian.ezauctions.ormlite.stmt.mapped.BaseMappedStatement;
import me.elian.ezauctions.ormlite.support.DatabaseConnection;
import me.elian.ezauctions.ormlite.support.GeneratedKeyHolder;
import me.elian.ezauctions.ormlite.table.TableInfo;

public class MappedCreate<T, ID>
extends BaseMappedStatement<T, ID> {
    private final String queryNextSequenceStmt;
    private String dataClassName;
    private int versionFieldTypeIndex;

    private MappedCreate(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, String queryNextSequenceStmt, int versionFieldTypeIndex) {
        super(dao, tableInfo, statement, argFieldTypes);
        this.dataClassName = tableInfo.getDataClass().getSimpleName();
        this.queryNextSequenceStmt = queryNextSequenceStmt;
        this.versionFieldTypeIndex = versionFieldTypeIndex;
    }

    public int insert(DatabaseType databaseType, DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        KeyHolder keyHolder = null;
        if (this.idField != null) {
            boolean assignId = !this.idField.isAllowGeneratedIdInsert() || this.idField.isObjectsFieldValueDefault(data);
            if (this.idField.isSelfGeneratedId() && this.idField.isGeneratedId()) {
                if (assignId) {
                    this.idField.assignField(this.connectionSource, data, this.idField.generateId(), false, objectCache);
                }
            } else if (this.idField.isGeneratedIdSequence() && databaseType.isSelectSequenceBeforeInsert()) {
                if (assignId) {
                    this.assignSequenceId(databaseConnection, data, objectCache);
                }
            } else if (this.idField.isGeneratedId() && assignId) {
                keyHolder = new KeyHolder(this.idField.getColumnName());
            }
        }
        try {
            int rowC;
            if (this.tableInfo.isForeignAutoCreate()) {
                for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
                    Object foreignObj;
                    if (!fieldType.isForeignAutoCreate() || (foreignObj = fieldType.extractRawJavaFieldValue(data)) == null || !fieldType.getForeignIdField().isObjectsFieldValueDefault(foreignObj)) continue;
                    fieldType.createWithForeignDao(foreignObj);
                }
            }
            Object[] args = this.getFieldObjects(data);
            Object versionDefaultValue = null;
            if (this.versionFieldTypeIndex >= 0 && args[this.versionFieldTypeIndex] == null) {
                FieldType versionFieldType = this.argFieldTypes[this.versionFieldTypeIndex];
                versionDefaultValue = versionFieldType.moveToNextValue(null);
                args[this.versionFieldTypeIndex] = versionFieldType.convertJavaFieldToSqlArgValue(versionDefaultValue);
            }
            try {
                rowC = databaseConnection.insert(this.statement, args, this.argFieldTypes, keyHolder);
            }
            catch (SQLException e) {
                logger.debug("insert data with statement '{}' and {} args, threw exception: {}", (Object)this.statement, (Object)args.length, (Object)e);
                if (args.length > 0) {
                    logger.trace("insert arguments: {}", (Object)args);
                }
                throw e;
            }
            logger.debug("insert data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("insert arguments: {}", (Object)args);
            }
            if (rowC > 0) {
                if (versionDefaultValue != null) {
                    this.argFieldTypes[this.versionFieldTypeIndex].assignField(this.connectionSource, data, versionDefaultValue, false, null);
                }
                if (keyHolder != null) {
                    Number key = keyHolder.getKey();
                    if (key == null) {
                        throw new SQLException("generated-id key was not set by the update call, maybe a schema mismatch between entity and database table?");
                    }
                    if (key.longValue() == 0L) {
                        throw new SQLException("generated-id key must not be 0 value, maybe a schema mismatch between entity and database table?");
                    }
                    this.assignIdValue(data, key, "keyholder", objectCache);
                }
                if (objectCache != null && this.foreignCollectionsAreAssigned(this.tableInfo.getForeignCollections(), data)) {
                    Object id = this.idField.extractJavaFieldValue(data);
                    objectCache.put(this.clazz, id, data);
                }
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run insert stmt on object " + data + ": " + this.statement, e);
        }
    }

    public static <T, ID> MappedCreate<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo) {
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        StringBuilder sb = new StringBuilder(128);
        MappedCreate.appendTableName(databaseType, sb, "INSERT INTO ", tableInfo);
        int argFieldC = 0;
        int versionFieldTypeIndex = -1;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!MappedCreate.isFieldCreatable(databaseType, fieldType)) continue;
            if (fieldType.isVersion()) {
                versionFieldTypeIndex = argFieldC;
            }
            ++argFieldC;
        }
        FieldType[] argFieldTypes = new FieldType[argFieldC];
        if (argFieldC == 0) {
            databaseType.appendInsertNoColumns(sb);
        } else {
            argFieldC = 0;
            boolean first = true;
            sb.append('(');
            for (FieldType fieldType : tableInfo.getFieldTypes()) {
                if (!MappedCreate.isFieldCreatable(databaseType, fieldType)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                MappedCreate.appendFieldColumnName(databaseType, sb, fieldType, null);
                argFieldTypes[argFieldC++] = fieldType;
            }
            sb.append(") VALUES (");
            first = true;
            for (FieldType fieldType : tableInfo.getFieldTypes()) {
                if (!MappedCreate.isFieldCreatable(databaseType, fieldType)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('?');
            }
            sb.append(')');
        }
        FieldType idField = tableInfo.getIdField();
        String queryNext = MappedCreate.buildQueryNextSequence(databaseType, idField);
        return new MappedCreate<T, ID>(dao, tableInfo, sb.toString(), argFieldTypes, queryNext, versionFieldTypeIndex);
    }

    private boolean foreignCollectionsAreAssigned(FieldType[] foreignCollections, Object data) throws SQLException {
        for (FieldType fieldType : foreignCollections) {
            if (fieldType.extractJavaFieldValue(data) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldCreatable(DatabaseType databaseType, FieldType fieldType) {
        if (fieldType.isForeignCollection()) {
            return false;
        }
        if (fieldType.isReadOnly()) {
            return false;
        }
        if (databaseType.isIdSequenceNeeded() && databaseType.isSelectSequenceBeforeInsert()) {
            return true;
        }
        return !fieldType.isGeneratedId() || fieldType.isSelfGeneratedId() || fieldType.isAllowGeneratedIdInsert();
    }

    private static String buildQueryNextSequence(DatabaseType databaseType, FieldType idField) {
        if (idField == null) {
            return null;
        }
        String seqName = idField.getGeneratedIdSequence();
        if (seqName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(64);
        databaseType.appendSelectNextValFromSequence(sb, seqName);
        return sb.toString();
    }

    private void assignSequenceId(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        long seqVal = databaseConnection.queryForLong(this.queryNextSequenceStmt);
        logger.debug("queried for sequence {} using stmt: {}", seqVal, (Object)this.queryNextSequenceStmt);
        if (seqVal == 0L) {
            throw new SQLException("Should not have returned 0 for stmt: " + this.queryNextSequenceStmt);
        }
        this.assignIdValue(data, seqVal, "sequence", objectCache);
    }

    private void assignIdValue(T data, Number val, String label, ObjectCache objectCache) throws SQLException {
        this.idField.assignIdValue(this.connectionSource, data, val, objectCache);
        if (logger.isLevelEnabled(Level.DEBUG)) {
            logger.debug("assigned id '{}' from {} to '{}' in {} object", new Object[]{val, label, this.idField.getFieldName(), this.dataClassName});
        }
    }

    private static class KeyHolder
    implements GeneratedKeyHolder {
        final String columnName;
        Number key;

        public KeyHolder(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        public Number getKey() {
            return this.key;
        }

        @Override
        public void addKey(Number key) throws SQLException {
            if (this.key != null) {
                throw new SQLException("generated key has already been set to " + this.key + ", trying now to set to " + key);
            }
            this.key = key;
        }
    }
}

