/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.stmt.mapped;

import java.sql.SQLException;
import java.util.Collection;
import me.elian.ezauctions.ormlite.dao.Dao;
import me.elian.ezauctions.ormlite.dao.ObjectCache;
import me.elian.ezauctions.ormlite.db.DatabaseType;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.stmt.mapped.BaseMappedStatement;
import me.elian.ezauctions.ormlite.support.DatabaseConnection;
import me.elian.ezauctions.ormlite.table.TableInfo;

public class MappedDeleteCollection<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedDeleteCollection(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(dao, tableInfo, statement, argFieldTypes);
    }

    public static <T, ID> int deleteObjects(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, DatabaseConnection databaseConnection, Collection<T> datas, ObjectCache objectCache) throws SQLException {
        MappedDeleteCollection<T, ID> deleteCollection = MappedDeleteCollection.build(dao, tableInfo, datas.size());
        Object[] fieldObjects = new Object[datas.size()];
        FieldType idField = tableInfo.getIdField();
        int objC = 0;
        for (T data : datas) {
            fieldObjects[objC] = idField.extractJavaFieldToSqlArgValue(data);
            ++objC;
        }
        return MappedDeleteCollection.updateRows(databaseConnection, tableInfo.getDataClass(), deleteCollection, fieldObjects, objectCache);
    }

    public static <T, ID> int deleteIds(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, DatabaseConnection databaseConnection, Collection<ID> ids, ObjectCache objectCache) throws SQLException {
        MappedDeleteCollection<T, ID> deleteCollection = MappedDeleteCollection.build(dao, tableInfo, ids.size());
        Object[] fieldObjects = new Object[ids.size()];
        FieldType idField = tableInfo.getIdField();
        int objC = 0;
        for (ID id : ids) {
            fieldObjects[objC] = idField.convertJavaFieldToSqlArgValue(id);
            ++objC;
        }
        return MappedDeleteCollection.updateRows(databaseConnection, tableInfo.getDataClass(), deleteCollection, fieldObjects, objectCache);
    }

    private static <T, ID> MappedDeleteCollection<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, int dataSize) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot delete " + tableInfo.getDataClass() + " because it doesn't have an id field defined");
        }
        StringBuilder sb = new StringBuilder(128);
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        MappedDeleteCollection.appendTableName(databaseType, sb, "DELETE FROM ", tableInfo);
        FieldType[] argFieldTypes = new FieldType[dataSize];
        MappedDeleteCollection.appendWhereIds(databaseType, idField, sb, dataSize, argFieldTypes);
        return new MappedDeleteCollection<T, ID>(dao, tableInfo, sb.toString(), argFieldTypes);
    }

    private static <T, ID> int updateRows(DatabaseConnection databaseConnection, Class<T> clazz, MappedDeleteCollection<T, ID> deleteCollection, Object[] args, ObjectCache objectCache) throws SQLException {
        try {
            int rowC = databaseConnection.delete(deleteCollection.statement, args, deleteCollection.argFieldTypes);
            if (rowC > 0 && objectCache != null) {
                for (Object id : args) {
                    objectCache.remove(clazz, id);
                }
            }
            logger.debug("delete-collection with statement '{}' and {} args, changed {} rows", (Object)deleteCollection.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("delete-collection arguments: {}", (Object)args);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run delete collection stmt: " + deleteCollection.statement, e);
        }
    }

    private static void appendWhereIds(DatabaseType databaseType, FieldType idField, StringBuilder sb, int numDatas, FieldType[] fieldTypes) {
        sb.append("WHERE ");
        databaseType.appendEscapedEntityName(sb, idField.getColumnName());
        sb.append(" IN (");
        boolean first = true;
        for (int i = 0; i < numDatas; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('?');
            if (fieldTypes == null) continue;
            fieldTypes[i] = idField;
        }
        sb.append(") ");
    }
}

