/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.stmt.mapped;

import java.sql.SQLException;
import me.elian.ezauctions.ormlite.dao.Dao;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.field.SqlType;
import me.elian.ezauctions.ormlite.logger.Level;
import me.elian.ezauctions.ormlite.misc.IOUtils;
import me.elian.ezauctions.ormlite.stmt.ArgumentHolder;
import me.elian.ezauctions.ormlite.stmt.PreparedDelete;
import me.elian.ezauctions.ormlite.stmt.PreparedQuery;
import me.elian.ezauctions.ormlite.stmt.PreparedUpdate;
import me.elian.ezauctions.ormlite.stmt.StatementBuilder;
import me.elian.ezauctions.ormlite.stmt.mapped.BaseMappedQuery;
import me.elian.ezauctions.ormlite.support.CompiledStatement;
import me.elian.ezauctions.ormlite.support.DatabaseConnection;
import me.elian.ezauctions.ormlite.table.TableInfo;

public class MappedPreparedStmt<T, ID>
extends BaseMappedQuery<T, ID>
implements PreparedQuery<T>,
PreparedDelete<T>,
PreparedUpdate<T> {
    private final ArgumentHolder[] argHolders;
    private final Long limit;
    private final StatementBuilder.StatementType type;
    private final boolean cacheStore;

    public MappedPreparedStmt(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultFieldTypes, ArgumentHolder[] argHolders, Long limit, StatementBuilder.StatementType type, boolean cacheStore) {
        super(dao, tableInfo, statement, argFieldTypes, resultFieldTypes);
        this.argHolders = argHolders;
        this.limit = limit;
        this.type = type;
        this.cacheStore = cacheStore;
    }

    @Override
    public CompiledStatement compile(DatabaseConnection databaseConnection, StatementBuilder.StatementType type) throws SQLException {
        return this.compile(databaseConnection, type, -1);
    }

    @Override
    public CompiledStatement compile(DatabaseConnection databaseConnection, StatementBuilder.StatementType type, int resultFlags) throws SQLException {
        if (this.type != type) {
            throw new SQLException("Could not compile this " + (Object)((Object)this.type) + " statement since the caller is expecting a " + (Object)((Object)type) + " statement.  Check your QueryBuilder methods.");
        }
        CompiledStatement stmt = databaseConnection.compileStatement(this.statement, type, this.argFieldTypes, resultFlags, this.cacheStore);
        return this.assignStatementArguments(stmt);
    }

    @Override
    public String getStatement() {
        return this.statement;
    }

    @Override
    public StatementBuilder.StatementType getType() {
        return this.type;
    }

    @Override
    public void setArgumentHolderValue(int index, Object value) throws SQLException {
        if (index < 0) {
            throw new SQLException("argument holder index " + index + " must be >= 0");
        }
        if (this.argHolders.length <= index) {
            throw new SQLException("argument holder index " + index + " is not valid, only " + this.argHolders.length + " in statement (index starts at 0)");
        }
        this.argHolders[index].setValue(value);
    }

    @Override
    public int getNumArgs() {
        if (this.argHolders == null) {
            return 0;
        }
        return this.argHolders.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledStatement assignStatementArguments(CompiledStatement stmt) throws SQLException {
        boolean ok = false;
        try {
            if (this.limit != null) {
                stmt.setMaxRows(this.limit.intValue());
            }
            Object[] argValues = null;
            if (logger.isLevelEnabled(Level.TRACE) && this.argHolders.length > 0) {
                argValues = new Object[this.argHolders.length];
            }
            for (int i = 0; i < this.argHolders.length; ++i) {
                Object argValue = this.argHolders[i].getSqlArgValue();
                FieldType fieldType = this.argFieldTypes[i];
                SqlType sqlType = fieldType == null ? this.argHolders[i].getSqlType() : fieldType.getSqlType();
                stmt.setObject(i, argValue, sqlType);
                if (argValues == null) continue;
                argValues[i] = argValue;
            }
            logger.debug("prepared statement '{}' with {} args", (Object)this.statement, (Object)this.argHolders.length);
            if (argValues != null) {
                logger.trace("prepared statement arguments: {}", (Object)argValues);
            }
            ok = true;
            CompiledStatement compiledStatement = stmt;
            return compiledStatement;
        }
        finally {
            if (!ok) {
                IOUtils.closeThrowSqlException(stmt, "statement");
            }
        }
    }
}

