/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.stmt.query;

import java.sql.SQLException;
import java.util.List;
import me.elian.ezauctions.ormlite.db.DatabaseType;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.stmt.ArgumentHolder;
import me.elian.ezauctions.ormlite.stmt.QueryBuilder;
import me.elian.ezauctions.ormlite.stmt.query.BaseComparison;

public class InSubQuery
extends BaseComparison {
    private final QueryBuilder.InternalQueryBuilderWrapper subQueryBuilder;
    private final boolean in;

    public InSubQuery(String columnName, FieldType fieldType, QueryBuilder.InternalQueryBuilderWrapper subQueryBuilder, boolean in) throws SQLException {
        super(columnName, fieldType, null, true);
        this.subQueryBuilder = subQueryBuilder;
        this.in = in;
    }

    @Override
    public void appendOperation(StringBuilder sb) {
        if (this.in) {
            sb.append("IN ");
        } else {
            sb.append("NOT IN ");
        }
    }

    @Override
    public void appendValue(DatabaseType databaseType, StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        int len;
        sb.append('(');
        this.subQueryBuilder.appendStatementString(sb, argList);
        FieldType[] resultFieldTypes = this.subQueryBuilder.getResultFieldTypes();
        if (resultFieldTypes != null) {
            if (resultFieldTypes.length != 1) {
                throw new SQLException("There must be only 1 result column in sub-query but we found " + resultFieldTypes.length);
            }
            if (this.fieldType.getSqlType() != resultFieldTypes[0].getSqlType()) {
                throw new SQLException("Outer column " + this.fieldType + " is not the same type as inner column " + resultFieldTypes[0]);
            }
        }
        if ((len = sb.length()) > 0 && sb.charAt(len - 1) == ' ') {
            sb.setLength(len - 1);
        }
        sb.append(") ");
    }
}

