/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.support;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import me.elian.ezauctions.ormlite.support.DatabaseConnection;
import me.elian.ezauctions.ormlite.support.DatabaseConnectionProxyFactory;

public class ReflectionDatabaseConnectionProxyFactory
implements DatabaseConnectionProxyFactory {
    private final Class<? extends DatabaseConnection> proxyClass;
    private final Constructor<? extends DatabaseConnection> constructor;

    public ReflectionDatabaseConnectionProxyFactory(Class<? extends DatabaseConnection> proxyClass) throws IllegalArgumentException {
        this.proxyClass = proxyClass;
        try {
            this.constructor = proxyClass.getConstructor(DatabaseConnection.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find constructor with DatabaseConnection argument in " + proxyClass);
        }
    }

    @Override
    public DatabaseConnection createProxy(DatabaseConnection realConnection) throws SQLException {
        try {
            return this.constructor.newInstance(realConnection);
        }
        catch (Exception e) {
            throw new SQLException("Could not create a new instance of " + this.proxyClass, e);
        }
    }
}

