/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.ormlite.table;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.elian.ezauctions.ormlite.db.DatabaseType;
import me.elian.ezauctions.ormlite.field.FieldType;
import me.elian.ezauctions.ormlite.table.DatabaseTableConfig;

public class TableInfo<T, ID> {
    private static final FieldType[] NO_FOREIGN_COLLECTIONS = new FieldType[0];
    private final DatabaseType databaseType;
    private final Class<T> dataClass;
    private final String schemaName;
    private final String tableName;
    private final FieldType[] fieldTypes;
    private final FieldType[] foreignCollections;
    private final FieldType idField;
    private final boolean foreignAutoCreate;
    private final Map<String, FieldType> fieldNameMap;

    public TableInfo(DatabaseType databaseType, Class<T> dataClass) throws SQLException {
        this(databaseType, DatabaseTableConfig.fromClass(databaseType, dataClass));
    }

    public TableInfo(DatabaseType databaseType, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this.databaseType = databaseType;
        this.dataClass = tableConfig.getDataClass();
        this.schemaName = tableConfig.getSchemaName();
        this.tableName = tableConfig.getTableName();
        this.fieldTypes = tableConfig.getFieldTypes(databaseType);
        FieldType findIdFieldType = null;
        boolean foreignAutoCreate = false;
        int foreignCollectionCount = 0;
        HashMap<String, FieldType> mutableFieldNameMap = new HashMap<String, FieldType>();
        for (FieldType fieldType : this.fieldTypes) {
            if (fieldType.isId() || fieldType.isGeneratedId() || fieldType.isGeneratedIdSequence()) {
                if (findIdFieldType != null) {
                    throw new SQLException("More than 1 idField configured for class " + this.dataClass + " (" + findIdFieldType + "," + fieldType + ")");
                }
                findIdFieldType = fieldType;
            }
            if (fieldType.isForeignAutoCreate()) {
                foreignAutoCreate = true;
            }
            if (fieldType.isForeignCollection()) {
                ++foreignCollectionCount;
            }
            mutableFieldNameMap.put(databaseType.downCaseString(fieldType.getColumnName(), true), fieldType);
        }
        this.fieldNameMap = Collections.unmodifiableMap(mutableFieldNameMap);
        this.idField = findIdFieldType;
        this.foreignAutoCreate = foreignAutoCreate;
        if (foreignCollectionCount == 0) {
            this.foreignCollections = NO_FOREIGN_COLLECTIONS;
        } else {
            this.foreignCollections = new FieldType[foreignCollectionCount];
            foreignCollectionCount = 0;
            for (FieldType fieldType : this.fieldTypes) {
                if (!fieldType.isForeignCollection()) continue;
                this.foreignCollections[foreignCollectionCount] = fieldType;
                ++foreignCollectionCount;
            }
        }
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public FieldType getFieldTypeByColumnName(String columnName) {
        String downColumnName = this.databaseType.downCaseString(columnName, true);
        FieldType match = this.fieldNameMap.get(downColumnName);
        if (match != null) {
            return match;
        }
        for (FieldType fieldType : this.fieldTypes) {
            String downFieldName = this.databaseType.downCaseString(fieldType.getFieldName(), true);
            if (!downFieldName.equals(downColumnName)) continue;
            String downFieldColumnName = this.databaseType.downCaseString(fieldType.getColumnName(), true);
            throw new IllegalArgumentException("Unknown column-name '" + downColumnName + "', maybe field-name instead of column-name '" + downFieldColumnName + "' from table '" + this.tableName + "' with columns: " + this.fieldNameMap.keySet());
        }
        throw new IllegalArgumentException("Unknown column-name '" + downColumnName + "' in table '" + this.tableName + "' with columns: " + this.fieldNameMap.keySet());
    }

    public FieldType getIdField() {
        return this.idField;
    }

    public String objectToString(T object) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(object.getClass().getSimpleName());
        for (FieldType fieldType : this.fieldTypes) {
            sb.append(' ').append(fieldType.getColumnName()).append('=');
            try {
                sb.append(fieldType.extractJavaFieldValue(object));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not generate toString of field " + fieldType, e);
            }
        }
        return sb.toString();
    }

    public boolean isUpdatable() {
        return this.idField != null && this.fieldTypes.length > 1;
    }

    public boolean isForeignAutoCreate() {
        return this.foreignAutoCreate;
    }

    public FieldType[] getForeignCollections() {
        return this.foreignCollections;
    }

    public boolean hasColumnName(String columnName) {
        for (FieldType fieldType : this.fieldTypes) {
            if (!fieldType.getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }
}

