/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scheduler;

import me.elian.ezauctions.Logger;
import me.elian.ezauctions.scheduler.CancellableTask;
import me.elian.ezauctions.scheduler.TaskScheduler;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class TaskSchedulerBase
implements TaskScheduler {
    private final Plugin plugin;
    private final Logger logger;
    private boolean shuttingDown;

    protected TaskSchedulerBase(@NotNull Plugin plugin, @NotNull Logger logger) {
        this.plugin = plugin;
        this.logger = logger;
    }

    @Override
    public void shutdown() {
        this.shuttingDown = true;
    }

    @Override
    public void runPlayerRegionTask(@NotNull Runnable runnable, @NotNull Player player) {
        Runnable wrapped = this.wrapRunnable(runnable);
        if (this.shuttingDown) {
            wrapped.run();
        } else {
            this.schedulePlayerRegionTask(this.plugin, wrapped, player);
        }
    }

    @Override
    public void runAsyncPlayerCommandTask(@NotNull Player player, @NotNull Runnable runnable) {
        if (this.shuttingDown) {
            runnable.run();
            return;
        }
        this.scheduleAsyncTask(this.plugin, () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.logger.severe("Exception occurred while processing command!", e);
                player.sendMessage((Component)Component.text("Errors occurred while processing your command. Please contact the server administrator."));
                throw e;
            }
        });
    }

    @Override
    public void runSyncTask(@NotNull Runnable runnable) {
        Runnable wrapped = this.wrapRunnable(runnable);
        if (this.shuttingDown) {
            wrapped.run();
        } else {
            this.scheduleGlobalSyncTask(this.plugin, wrapped);
        }
    }

    @Override
    public void runAsyncTask(@NotNull Runnable runnable) {
        Runnable wrapped = this.wrapRunnable(runnable);
        if (this.shuttingDown) {
            wrapped.run();
        } else {
            this.scheduleAsyncTask(this.plugin, wrapped);
        }
    }

    @Override
    public void runAsyncDelayedTask(@NotNull Runnable runnable, long delaySeconds) {
        Runnable wrapped = this.wrapRunnable(runnable);
        if (this.shuttingDown) {
            wrapped.run();
        } else {
            this.scheduleAsyncDelayedTask(this.plugin, wrapped, delaySeconds);
        }
    }

    @Override
    public CancellableTask runAsyncRepeatingTask(@NotNull Plugin plugin, @NotNull Runnable runnable, long initialDelaySeconds, long intervalSeconds) {
        if (this.shuttingDown) {
            throw new IllegalStateException("Cannot schedule a repeating task while server shutting down!");
        }
        return this.scheduleAsyncRepeatingTask(plugin, runnable, initialDelaySeconds, intervalSeconds);
    }

    protected abstract void schedulePlayerRegionTask(Plugin var1, Runnable var2, Player var3);

    protected abstract void scheduleGlobalSyncTask(@NotNull Plugin var1, @NotNull Runnable var2);

    protected abstract void scheduleAsyncTask(@NotNull Plugin var1, @NotNull Runnable var2);

    protected abstract void scheduleAsyncDelayedTask(@NotNull Plugin var1, @NotNull Runnable var2, long var3);

    protected abstract CancellableTask scheduleAsyncRepeatingTask(@NotNull Plugin var1, @NotNull Runnable var2, long var3, long var5);

    private Runnable wrapRunnable(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                this.logger.severe("Exception occurred while processing task!", e);
                throw e;
            }
        };
    }
}

