/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.api.sidebar.component;

import com.google.common.base.Preconditions;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ScoreFormat;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.Sidebar;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.component.LineDrawable;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.component.SidebarComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentSidebarLayout {
    private final SidebarComponent titleComponent;
    private final SidebarComponent linesComponent;

    public ComponentSidebarLayout(@NotNull SidebarComponent titleComponent, @NotNull SidebarComponent linesComponent) {
        Preconditions.checkNotNull((Object)titleComponent);
        Preconditions.checkNotNull((Object)linesComponent);
        this.titleComponent = titleComponent;
        this.linesComponent = linesComponent;
    }

    @NotNull
    public SidebarComponent titleComponent() {
        return this.titleComponent;
    }

    @NotNull
    public SidebarComponent linesComponent() {
        return this.linesComponent;
    }

    public void apply(@NotNull Sidebar sidebar) {
        Preconditions.checkNotNull((Object)sidebar);
        SidebarTitleDrawable titleDrawable = new SidebarTitleDrawable();
        this.titleComponent.draw(titleDrawable);
        sidebar.title(titleDrawable.title == null ? Component.empty() : titleDrawable.title);
        SidebarLineDrawable linesDrawable = new SidebarLineDrawable(sidebar);
        this.linesComponent.draw(linesDrawable);
        for (int i = linesDrawable.index; i < 15; ++i) {
            sidebar.line(i, null);
        }
    }

    private static class SidebarTitleDrawable
    implements LineDrawable {
        private Component title;

        private SidebarTitleDrawable() {
        }

        @Override
        public void drawLine(@NotNull ComponentLike line, @Nullable ScoreFormat scoreFormat) {
            Preconditions.checkNotNull((Object)line);
            if (this.title == null) {
                this.title = line.asComponent();
            }
        }
    }

    private static class SidebarLineDrawable
    implements LineDrawable {
        private final Sidebar sidebar;
        private int index = 0;

        public SidebarLineDrawable(@NotNull Sidebar sidebar) {
            this.sidebar = sidebar;
        }

        @Override
        public void drawLine(@NotNull ComponentLike line, @Nullable ScoreFormat scoreFormat) {
            Preconditions.checkNotNull((Object)line);
            if (this.index < 15) {
                this.sidebar.line(this.index++, line, scoreFormat);
            }
        }
    }
}

