/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.api.sidebar.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ScoreFormat;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.component.LineDrawable;
import me.elian.ezauctions.scoreboardlibrary.api.sidebar.component.animation.SidebarAnimation;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.jetbrains.annotations.NotNull;

public interface SidebarComponent {
    @NotNull
    public static SidebarComponent staticLine(@NotNull ComponentLike line) {
        Preconditions.checkNotNull((Object)line);
        return drawable -> drawable.drawLine(line);
    }

    @NotNull
    public static SidebarComponent staticLine(@NotNull ComponentLike line, @NotNull ScoreFormat scoreFormat) {
        Preconditions.checkNotNull((Object)line);
        return drawable -> drawable.drawLine(line, scoreFormat);
    }

    @NotNull
    public static SidebarComponent blankLine() {
        return drawable -> drawable.drawLine(Component.empty());
    }

    @NotNull
    public static <T extends ComponentLike> SidebarComponent dynamicLine(@NotNull Supplier<T> lineSupplier) {
        return drawable -> drawable.drawLine((ComponentLike)lineSupplier.get());
    }

    @NotNull
    public static <T extends ComponentLike> SidebarComponent animatedLine(@NotNull SidebarAnimation<T> animation) {
        Preconditions.checkNotNull(animation);
        return drawable -> drawable.drawLine((ComponentLike)animation.currentFrame());
    }

    @NotNull
    public static <T extends SidebarComponent> SidebarComponent animatedComponent(@NotNull SidebarAnimation<T> animation) {
        Preconditions.checkNotNull(animation);
        return drawable -> ((SidebarComponent)animation.currentFrame()).draw(drawable);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public void draw(@NotNull LineDrawable var1);

    public static final class Builder {
        private final List<SidebarComponent> children = new ArrayList<SidebarComponent>(4);

        private Builder() {
        }

        @NotNull
        public Builder addComponent(@NotNull SidebarComponent component) {
            Preconditions.checkNotNull((Object)component);
            this.children.add(component);
            return this;
        }

        @NotNull
        public Builder addStaticLine(@NotNull ComponentLike line) {
            return this.addComponent(SidebarComponent.staticLine(line));
        }

        @NotNull
        public Builder addStaticLine(@NotNull ComponentLike line, @NotNull ScoreFormat scoreFormat) {
            return this.addComponent(SidebarComponent.staticLine(line, scoreFormat));
        }

        @NotNull
        public Builder addBlankLine() {
            return this.addComponent(SidebarComponent.blankLine());
        }

        @NotNull
        public <T extends ComponentLike> Builder addDynamicLine(@NotNull Supplier<T> lineSupplier) {
            return this.addComponent(SidebarComponent.dynamicLine(lineSupplier));
        }

        @NotNull
        public <T extends ComponentLike> Builder addAnimatedLine(@NotNull SidebarAnimation<T> animation) {
            return this.addComponent(SidebarComponent.animatedLine(animation));
        }

        @NotNull
        public <T extends SidebarComponent> Builder addAnimatedComponent(@NotNull SidebarAnimation<T> animation) {
            return this.addComponent(SidebarComponent.animatedComponent(animation));
        }

        @NotNull
        public SidebarComponent build() {
            ImmutableList children = ImmutableList.copyOf(this.children);
            return drawable -> {
                for (SidebarComponent child : children) {
                    child.draw(drawable);
                }
            };
        }
    }
}

