/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.commons;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.function.Function;
import net.kyori.adventure.translation.Translator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocaleProvider {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final Function<Player, Locale> provider = LocaleProvider.get();

    @NotNull
    public static Locale locale(Player player) {
        return provider.apply(player);
    }

    @NotNull
    private static Function<Player, Locale> get() {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            MethodHandle adventureMethod = lookup.findVirtual(Player.class, "locale", MethodType.methodType(Locale.class));
            return player -> {
                try {
                    return adventureMethod.invokeExact((Player)player);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (IllegalAccessException | NoSuchMethodException adventureMethod) {
            MethodType methodType = MethodType.methodType(String.class);
            try {
                MethodHandle legacySpigotMethod = lookup.findVirtual(Player.Spigot.class, "getLocale", methodType);
                return player -> {
                    try {
                        Locale locale = Translator.parseLocale(legacySpigotMethod.invokeExact(player.spigot()));
                        return locale == null ? DEFAULT_LOCALE : locale;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException legacySpigotMethod) {
                try {
                    MethodHandle legacyMethod = lookup.findVirtual(Player.class, "getLocale", methodType);
                    return player -> {
                        try {
                            @Nullable Locale locale = Translator.parseLocale(legacyMethod.invokeExact((Player)player));
                            return locale == null ? DEFAULT_LOCALE : locale;
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                catch (IllegalAccessException | NoSuchMethodException ignored) {
                    throw new RuntimeException("No way to get players locale found");
                }
            }
        }
    }
}

