/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.objective;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ObjectiveManager;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ObjectiveScore;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ScoreboardObjective;
import me.elian.ezauctions.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import me.elian.ezauctions.scoreboardlibrary.implementation.commons.CollectionProvider;
import me.elian.ezauctions.scoreboardlibrary.implementation.objective.ObjectiveManagerTask;
import me.elian.ezauctions.scoreboardlibrary.implementation.objective.ScoreboardObjectiveImpl;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.elian.ezauctions.scoreboardlibrary.implementation.player.PlayerDisplayable;
import me.elian.ezauctions.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ObjectiveManagerImpl
implements ObjectiveManager,
PlayerDisplayable {
    private final ScoreboardLibraryImpl library;
    private final Map<String, ScoreboardObjectiveImpl> objectives = new ConcurrentHashMap<String, ScoreboardObjectiveImpl>();
    private final Map<ObjectiveDisplaySlot, ScoreboardObjectiveImpl> displaySlots = new HashMap<ObjectiveDisplaySlot, ScoreboardObjectiveImpl>();
    private final Set<Player> players = CollectionProvider.set(8);
    private final Set<Player> displayingPlayers = CollectionProvider.set(8);
    private final Queue<ObjectiveManagerTask> taskQueue = new ConcurrentLinkedQueue<ObjectiveManagerTask>();
    private boolean closed;

    public ObjectiveManagerImpl(@NotNull ScoreboardLibraryImpl library) {
        this.library = library;
    }

    @NotNull
    public Queue<ObjectiveManagerTask> taskQueue() {
        return this.taskQueue;
    }

    @Override
    @NotNull
    public ScoreboardObjective create(@NotNull String name) {
        Preconditions.checkNotNull((Object)name);
        this.checkClosed();
        return this.objectives.computeIfAbsent(name, i -> {
            ObjectivePacketAdapter packetAdapter = this.library.packetAdapter().createObjectiveAdapter(name);
            ScoreboardObjectiveImpl objective = new ScoreboardObjectiveImpl(packetAdapter, this.taskQueue, name);
            this.taskQueue.add(new ObjectiveManagerTask.AddObjective(objective));
            return objective;
        });
    }

    @Override
    public void remove(@NotNull ScoreboardObjective objective) {
        Preconditions.checkNotNull((Object)objective);
        this.checkClosed();
        if (!(objective instanceof ScoreboardObjectiveImpl)) {
            return;
        }
        ScoreboardObjectiveImpl impl = (ScoreboardObjectiveImpl)objective;
        if (this.objectives.values().remove(impl)) {
            this.displaySlots.values().removeIf(e -> e == impl);
            impl.close();
            this.taskQueue.add(new ObjectiveManagerTask.RemoveObjective(impl));
        }
    }

    @Override
    public void display(@NotNull ObjectiveDisplaySlot displaySlot, @NotNull ScoreboardObjective objective) {
        Preconditions.checkNotNull((Object)displaySlot);
        Preconditions.checkNotNull((Object)objective);
        this.checkClosed();
        if (!(objective instanceof ScoreboardObjectiveImpl)) {
            throw new IllegalArgumentException("Invalid objective implementation");
        }
        ScoreboardObjectiveImpl impl = (ScoreboardObjectiveImpl)objective;
        if (this.objectives.get(impl.name()) != impl) {
            throw new IllegalArgumentException("Objective is from a different manager");
        }
        this.displaySlots.put(displaySlot, impl);
        this.taskQueue.add(new ObjectiveManagerTask.UpdateDisplaySlot(displaySlot, impl));
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return Collections.unmodifiableSet(this.players);
    }

    @Override
    public boolean addPlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.add(player)) {
            return false;
        }
        this.taskQueue.add(new ObjectiveManagerTask.AddPlayer(player));
        return true;
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.remove(player)) {
            return false;
        }
        this.taskQueue.add(new ObjectiveManagerTask.RemovePlayer(player));
        return true;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskQueue.add(ObjectiveManagerTask.Close.INSTANCE);
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    public boolean tick() {
        ObjectiveManagerTask task;
        while ((task = this.taskQueue.poll()) != null) {
            ScoreboardObjectiveImpl objective;
            Set<Player> singleton;
            Player player;
            if (task instanceof ObjectiveManagerTask.Close) {
                for (ScoreboardObjectiveImpl objective2 : this.objectives.values()) {
                    objective2.packetAdapter().remove(this.displayingPlayers);
                }
                for (Player player2 : this.players) {
                    Objects.requireNonNull(this.library.getPlayer(player2)).objectiveManagerQueue().remove(this);
                }
                return false;
            }
            if (task instanceof ObjectiveManagerTask.AddPlayer) {
                player = ((ObjectiveManagerTask.AddPlayer)task).player();
                @NotNull ScoreboardLibraryPlayer slPlayer = this.library.getOrCreatePlayer(player);
                slPlayer.objectiveManagerQueue().add(this);
                continue;
            }
            if (task instanceof ObjectiveManagerTask.RemovePlayer) {
                player = ((ObjectiveManagerTask.RemovePlayer)task).player();
                singleton = Collections.singleton(player);
                for (ScoreboardObjectiveImpl objective3 : this.objectives.values()) {
                    objective3.packetAdapter().remove(singleton);
                }
                this.displayingPlayers.remove(player);
                Objects.requireNonNull(this.library.getPlayer(player)).objectiveManagerQueue().remove(this);
                continue;
            }
            if (task instanceof ObjectiveManagerTask.ReloadPlayer) {
                player = ((ObjectiveManagerTask.ReloadPlayer)task).player();
                singleton = Collections.singleton(player);
                for (ScoreboardObjectiveImpl objective3 : this.objectives.values()) {
                    objective3.sendProperties(singleton, PropertiesPacketType.UPDATE);
                    for (Map.Entry<String, ObjectiveScore> entry : objective3.scores().entrySet()) {
                        ObjectiveScore score = entry.getValue();
                        objective3.packetAdapter().sendScore(singleton, entry.getKey(), score.value(), score.displayName(), score.format());
                    }
                }
                continue;
            }
            if (task instanceof ObjectiveManagerTask.AddObjective) {
                objective = ((ObjectiveManagerTask.AddObjective)task).objective();
                objective.sendProperties(this.displayingPlayers, PropertiesPacketType.CREATE);
                continue;
            }
            if (task instanceof ObjectiveManagerTask.RemoveObjective) {
                objective = ((ObjectiveManagerTask.RemoveObjective)task).objective();
                objective.packetAdapter().remove(this.displayingPlayers);
                continue;
            }
            if (task instanceof ObjectiveManagerTask.UpdateObjective) {
                objective = ((ObjectiveManagerTask.UpdateObjective)task).objective();
                objective.sendProperties(this.displayingPlayers, PropertiesPacketType.UPDATE);
                continue;
            }
            if (task instanceof ObjectiveManagerTask.UpdateScore) {
                ScoreboardObjectiveImpl objective2;
                ObjectiveManagerTask.UpdateScore updateScoreTask = (ObjectiveManagerTask.UpdateScore)task;
                objective2 = updateScoreTask.objective();
                String entry = updateScoreTask.entry();
                ObjectiveScore score = updateScoreTask.score();
                if (score != null) {
                    objective2.packetAdapter().sendScore(this.displayingPlayers, entry, score.value(), score.displayName(), score.format());
                    continue;
                }
                objective2.packetAdapter().removeScore(this.displayingPlayers, entry);
                continue;
            }
            if (!(task instanceof ObjectiveManagerTask.UpdateDisplaySlot)) continue;
            ObjectiveManagerTask.UpdateDisplaySlot updateDisplaySlotTask = (ObjectiveManagerTask.UpdateDisplaySlot)task;
            ObjectiveDisplaySlot slot = updateDisplaySlotTask.displaySlot();
            ScoreboardObjectiveImpl objective4 = updateDisplaySlotTask.objective();
            objective4.packetAdapter().display(this.displayingPlayers, slot);
        }
        return true;
    }

    @Override
    public void display(@NotNull Player player) {
        this.displayingPlayers.add(player);
        Set<Player> singleton = Collections.singleton(player);
        for (ScoreboardObjectiveImpl scoreboardObjectiveImpl : this.objectives.values()) {
            scoreboardObjectiveImpl.sendProperties(singleton, PropertiesPacketType.CREATE);
            for (Map.Entry<String, ObjectiveScore> entry : scoreboardObjectiveImpl.scores().entrySet()) {
                ObjectiveScore score = entry.getValue();
                scoreboardObjectiveImpl.packetAdapter().sendScore(singleton, entry.getKey(), score.value(), score.displayName(), score.format());
            }
        }
        for (Map.Entry entry : this.displaySlots.entrySet()) {
            ((ScoreboardObjectiveImpl)entry.getValue()).packetAdapter().display(singleton, (ObjectiveDisplaySlot)entry.getKey());
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ObjectiveManager is closed");
        }
    }
}

