/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.objective;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ObjectiveScore;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ScoreFormat;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ScoreboardObjective;
import me.elian.ezauctions.scoreboardlibrary.implementation.objective.ObjectiveManagerTask;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardObjectiveImpl
implements ScoreboardObjective {
    private final ObjectivePacketAdapter packetAdapter;
    private final Queue<ObjectiveManagerTask> taskQueue;
    private final String name;
    private final Map<String, ObjectiveScore> scores = new HashMap<String, ObjectiveScore>();
    private Component value = Component.empty();
    private ObjectiveRenderType renderType = ObjectiveRenderType.INTEGER;
    private ScoreFormat defaultScoreFormat;
    private boolean closed;

    public ScoreboardObjectiveImpl(@NotNull ObjectivePacketAdapter packetAdapter, @NotNull Queue<ObjectiveManagerTask> taskQueue, @NotNull String name) {
        this.packetAdapter = packetAdapter;
        this.taskQueue = taskQueue;
        this.name = name;
    }

    public ObjectivePacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public Map<String, ObjectiveScore> scores() {
        return this.scores;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public void close() {
        this.closed = true;
    }

    @Override
    @NotNull
    public Component value() {
        return this.value;
    }

    @Override
    @NotNull
    public ScoreboardObjective value(@NotNull ComponentLike value) {
        Component component = value.asComponent();
        if (!this.value.equals(component)) {
            this.value = component;
            if (!this.closed) {
                this.taskQueue.add(new ObjectiveManagerTask.UpdateObjective(this));
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ObjectiveRenderType renderType() {
        return this.renderType;
    }

    @Override
    @NotNull
    public ScoreboardObjective renderType(@NotNull ObjectiveRenderType renderType) {
        if (this.renderType != renderType) {
            this.renderType = renderType;
            if (!this.closed) {
                this.taskQueue.add(new ObjectiveManagerTask.UpdateObjective(this));
            }
        }
        return this;
    }

    @Override
    @Nullable
    public ScoreFormat defaultScoreFormat() {
        return this.defaultScoreFormat;
    }

    @Override
    public void defaultScoreFormat(@Nullable ScoreFormat defaultScoreFormat) {
        if (!Objects.equals(this.defaultScoreFormat, defaultScoreFormat)) {
            this.defaultScoreFormat = defaultScoreFormat;
            this.taskQueue.add(new ObjectiveManagerTask.UpdateObjective(this));
        }
    }

    @Override
    @Nullable
    public ObjectiveScore scoreInfo(@NotNull String entry) {
        return this.scores.get(entry);
    }

    @Override
    @NotNull
    public ScoreboardObjective score(@NotNull String entry, ObjectiveScore score) {
        ObjectiveScore oldScore = this.scores.put(entry, score);
        if (!Objects.equals(oldScore, score)) {
            this.taskQueue.add(new ObjectiveManagerTask.UpdateScore(this, entry, score));
        }
        return this;
    }

    @Override
    @NotNull
    public ScoreboardObjective removeScore(@NotNull String entry) {
        if (this.scores.remove(entry) != null) {
            this.taskQueue.add(new ObjectiveManagerTask.UpdateScore(this, entry, null));
        }
        return this;
    }

    public void sendProperties(@NotNull Collection<Player> players, @NotNull PropertiesPacketType packetType) {
        this.packetAdapter.sendProperties(players, packetType, this.value, this.renderType, this.defaultScoreFormat);
    }
}

