/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern;

import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Locale;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.util.NativeAdventureUtil;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.util.RegistryUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentProviderImpl
implements ComponentProvider {
    private static final MethodHandle FROM_JSON_METHOD;
    private final boolean isNativeAdventure;

    public ComponentProviderImpl(boolean isNativeAdventure) {
        this.isNativeAdventure = isNativeAdventure;
    }

    @Override
    public @NotNull IChatBaseComponent fromAdventure(@NotNull Component adventure, @Nullable Locale locale) {
        if (this.isNativeAdventure) {
            return NativeAdventureUtil.fromAdventureComponent(adventure);
        }
        Component translated = adventure;
        if (locale != null) {
            translated = GlobalTranslator.render(adventure, locale);
        }
        JsonElement json = GsonComponentSerializer.gson().serializeToTree(translated);
        Object[] args = PacketAccessors.IS_1_20_5_OR_ABOVE ? new Object[]{json, RegistryUtil.MINECRAFT_REGISTRY} : new Object[]{json};
        try {
            return (IChatBaseComponent)FROM_JSON_METHOD.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MethodHandle handle = null;
        for (Method method : IChatBaseComponent.ChatSerializer.class.getMethods()) {
            if (method.getReturnType() != IChatMutableComponent.class || method.getParameterCount() < 1 || method.getParameterCount() > 2 || method.getParameterTypes()[0] != JsonElement.class) continue;
            try {
                handle = MethodHandles.lookup().unreflect(method);
                break;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (handle == null) {
            throw new ExceptionInInitializerError("failed to find chat component fromJson method");
        }
        FROM_JSON_METHOD = handle;
    }
}

