/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.objective;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ObjectiveDisplaySlot;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ObjectiveRenderType;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.PacketSender;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.objective.DisplaySlotProvider;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.objective.ObjectiveConstants;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.util.reflect.ReflectUtil;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractObjectivePacketAdapter
implements ObjectivePacketAdapter {
    protected final PacketSender<Packet<?>> sender;
    protected final ComponentProvider componentProvider;
    protected final String objectiveName;
    private PacketPlayOutScoreboardObjective removePacket;

    public AbstractObjectivePacketAdapter(@NotNull PacketSender<Packet<?>> sender, @NotNull ComponentProvider componentProvider, @NotNull String objectiveName) {
        this.sender = sender;
        this.componentProvider = componentProvider;
        this.objectiveName = objectiveName;
    }

    @Override
    public void display(@NotNull Collection<Player> players, @NotNull ObjectiveDisplaySlot slot) {
        this.sender.sendPacket((Iterable<Player>)players, (Packet<?>)this.createDisplayPacket(slot));
    }

    @Override
    public void remove(@NotNull Collection<Player> players) {
        if (this.removePacket == null) {
            this.removePacket = ReflectUtil.getEmptyConstructor(PacketPlayOutScoreboardObjective.class).invoke();
            PacketAccessors.OBJECTIVE_NAME_FIELD.set(this.removePacket, this.objectiveName);
            PacketAccessors.OBJECTIVE_MODE_FIELD.set(this.removePacket, 1);
        }
        this.sender.sendPacket((Iterable<Player>)players, (Packet<?>)this.removePacket);
    }

    @Override
    public void removeScore(@NotNull Collection<Player> players, @NotNull String entry) {
        Object packet = PacketAccessors.IS_1_20_3_OR_ABOVE ? new ClientboundResetScorePacket(entry, this.objectiveName) : (Packet)Objects.requireNonNull(PacketAccessors.SCORE_1_20_2_CONSTRUCTOR).invoke(ScoreboardServer.Action.b, this.objectiveName, entry, 0);
        this.sender.sendPacket((Iterable<Player>)players, (Packet<?>)packet);
    }

    @NotNull
    protected PacketPlayOutScoreboardDisplayObjective createDisplayPacket(@NotNull ObjectiveDisplaySlot displaySlot) {
        PacketPlayOutScoreboardDisplayObjective packet = PacketAccessors.IS_1_20_2_OR_ABOVE ? new PacketPlayOutScoreboardDisplayObjective(DisplaySlotProvider.toNms(displaySlot), null) : Objects.requireNonNull(PacketAccessors.DISPLAY_1_20_1_CONSTRUCTOR).invoke(ObjectiveConstants.displaySlotIndex(displaySlot), null);
        PacketAccessors.DISPLAY_OBJECTIVE_NAME.set(packet, this.objectiveName);
        return packet;
    }

    @NotNull
    protected PacketPlayOutScoreboardScore createScorePacket(@NotNull String entry, int value, @Nullable IChatBaseComponent nmsDisplay, @Nullable Object numberFormat) {
        if (PacketAccessors.IS_1_20_5_OR_ABOVE) {
            return new PacketPlayOutScoreboardScore(entry, this.objectiveName, value, Optional.ofNullable(nmsDisplay), Optional.ofNullable((NumberFormat)numberFormat));
        }
        if (PacketAccessors.IS_1_20_3_OR_ABOVE) {
            return Objects.requireNonNull(PacketAccessors.SCORE_1_20_3_CONSTRUCTOR).invoke(entry, this.objectiveName, value, nmsDisplay, numberFormat);
        }
        return Objects.requireNonNull(PacketAccessors.SCORE_1_20_2_CONSTRUCTOR).invoke(ScoreboardServer.Action.a, this.objectiveName, entry, value);
    }

    @NotNull
    protected PacketPlayOutScoreboardObjective createObjectivePacket(@NotNull PropertiesPacketType packetType, @NotNull IChatBaseComponent nmsValue, @NotNull ObjectiveRenderType renderType, @Nullable Object numberFormat) {
        IScoreboardCriteria.EnumScoreboardHealthDisplay nmsRenderType;
        PacketPlayOutScoreboardObjective packet = PacketAccessors.OBJECTIVE_PACKET_CONSTRUCTOR.invoke();
        PacketAccessors.OBJECTIVE_MODE_FIELD.set(packet, ObjectiveConstants.mode(packetType));
        PacketAccessors.OBJECTIVE_NAME_FIELD.set(packet, this.objectiveName);
        PacketAccessors.OBJECTIVE_VALUE_FIELD.set(packet, nmsValue);
        if (PacketAccessors.IS_1_20_3_OR_ABOVE) {
            assert (PacketAccessors.OBJECTIVE_NUMBER_FORMAT_FIELD != null);
            Optional<Object> value = PacketAccessors.IS_1_20_5_OR_ABOVE ? Optional.ofNullable(numberFormat) : numberFormat;
            PacketAccessors.OBJECTIVE_NUMBER_FORMAT_FIELD.set(packet, value);
        }
        switch (renderType) {
            case INTEGER: {
                nmsRenderType = IScoreboardCriteria.EnumScoreboardHealthDisplay.a;
                break;
            }
            case HEARTS: {
                nmsRenderType = IScoreboardCriteria.EnumScoreboardHealthDisplay.b;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        PacketAccessors.OBJECTIVE_RENDER_TYPE_FIELD.set(packet, nmsRenderType);
        return packet;
    }
}

