/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.objective;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.Optional;
import me.elian.ezauctions.scoreboardlibrary.api.objective.ScoreFormat;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScoreFormatConverter {
    private static final MethodHandle RESULT_UNWRAP_METHOD;

    private ScoreFormatConverter() {
    }

    @Nullable
    public static Object convert(@NotNull ComponentProvider componentProvider, @Nullable Locale locale, @Nullable ScoreFormat format) {
        if (format == null || !PacketAccessors.IS_1_20_3_OR_ABOVE) {
            return null;
        }
        if (format == ScoreFormat.blank()) {
            return BlankFormat.a;
        }
        if (format instanceof ScoreFormat.Styled) {
            ChatModifier style;
            JsonElement json = GsonComponentSerializer.gson().serializer().toJsonTree((Object)((ScoreFormat.Styled)format).style());
            DataResult result = ChatModifier.ChatModifierSerializer.b.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            try {
                style = (ChatModifier)RESULT_UNWRAP_METHOD.invokeExact(result).orElseThrow(RuntimeException::new);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return new StyledFormat(style);
        }
        if (format instanceof ScoreFormat.Fixed) {
            return new FixedFormat(componentProvider.fromAdventure(((ScoreFormat.Fixed)format).content(), locale));
        }
        throw new IllegalArgumentException("Invalid score format: " + format);
    }

    static {
        try {
            RESULT_UNWRAP_METHOD = MethodHandles.lookup().findVirtual(DataResult.class, "result", MethodType.methodType(Optional.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

