/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.modern.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PacketUtil {
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle SEND_PACKET;

    private PacketUtil() {
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        try {
            EntityPlayer handle = GET_HANDLE.invoke(player);
            PlayerConnection connection = PLAYER_CONNECTION.invoke(handle);
            SEND_PACKET.invoke(connection, packet);
        }
        catch (Throwable e) {
            throw new IllegalStateException("couldn't send packet to player", e);
        }
    }

    static {
        String[] sendPacketNames;
        MethodHandle playerConnection;
        Class<?> craftPlayer;
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        try {
            craftPlayer = Class.forName(cbPackage + ".entity.CraftPlayer");
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType methodType = MethodType.methodType(EntityPlayer.class);
        try {
            GET_HANDLE = lookup.findVirtual(craftPlayer, "getHandle", methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            playerConnection = lookup.findGetter(EntityPlayer.class, "c", PlayerConnection.class);
        }
        catch (NoSuchFieldException e) {
            try {
                playerConnection = lookup.findGetter(EntityPlayer.class, "b", PlayerConnection.class);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
        PLAYER_CONNECTION = playerConnection;
        MethodType sendMethodType = MethodType.methodType(Void.TYPE, Packet.class);
        MethodHandle sendPacket = null;
        for (String name : sendPacketNames = new String[]{"a", "sendPacket", "b"}) {
            try {
                sendPacket = lookup.findVirtual(PlayerConnection.class, name, sendMethodType);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        if (sendPacket == null) {
            throw new ExceptionInInitializerError(new RuntimeException("Couldn't find send packet method"));
        }
        SEND_PACKET = sendPacket;
    }
}

