/*
 * Decompiled with CFR 0.152.
 */
package me.elian.ezauctions.scoreboardlibrary.implementation.sidebar.line.locale;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import me.elian.ezauctions.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import me.elian.ezauctions.scoreboardlibrary.implementation.sidebar.line.GlobalLineInfo;
import me.elian.ezauctions.scoreboardlibrary.implementation.sidebar.line.SidebarLineHandler;
import me.elian.ezauctions.scoreboardlibrary.implementation.sidebar.line.locale.LocaleLine;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LegacyLocaleLine
implements LocaleLine,
ImmutableTeamProperties<String> {
    private final GlobalLineInfo info;
    private final SidebarLineHandler handler;
    private final TeamDisplayPacketAdapter packetAdapter;
    private String player;
    private String oldPlayer;
    private String prefix;
    private String suffix;
    private String currentValue;

    public LegacyLocaleLine(GlobalLineInfo info, SidebarLineHandler handler) {
        this.info = info;
        this.handler = handler;
        this.player = info.player();
        this.packetAdapter = info.packetAdapter().createLegacyTeamDisplayAdapter(this);
        this.packetAdapter.updateTeamPackets();
    }

    @Override
    @NotNull
    public GlobalLineInfo info() {
        return this.info;
    }

    @Override
    @NotNull
    public String displayName() {
        return "";
    }

    @Override
    @NotNull
    public String prefix() {
        return this.prefix;
    }

    @Override
    @NotNull
    public String suffix() {
        return this.suffix;
    }

    @Override
    @NotNull
    public Collection<String> syncedEntries() {
        return ImmutableList.of((Object)this.player);
    }

    @Override
    public void value(@NotNull Component renderedComponent) {
        String legacyValue = LegacyComponentSerializer.legacySection().serialize(renderedComponent);
        String prevPlayer = this.player;
        if (legacyValue.length() <= 16) {
            this.prefix = legacyValue;
            this.suffix = "";
            if (this.currentValue != null && this.currentValue.length() > 32) {
                this.player = this.info.player();
            }
        } else {
            boolean endsWithSection = legacyValue.charAt(15) == '\u00a7';
            int prefixEnd = endsWithSection ? 15 : 16;
            this.prefix = legacyValue.substring(0, prefixEnd);
            String last = this.prefix + '\u00a7' + (endsWithSection ? Character.valueOf(legacyValue.charAt(16)) : "");
            this.player = this.info.player() + ChatColor.getLastColors((String)last);
            int playerEnd = prefixEnd;
            if (legacyValue.length() > 32) {
                int remaining = 16 - this.player.length();
                assert (remaining > 0);
                this.player = this.player + legacyValue.substring(prefixEnd, playerEnd += remaining);
            }
            this.suffix = ChatColor.getLastColors((String)this.player) + legacyValue.substring(playerEnd + (endsWithSection ? 2 : 0));
            if (this.suffix.length() > 16) {
                String newSuffix = this.suffix.substring(0, 16);
                if (newSuffix.endsWith(String.valueOf('\u00a7'))) {
                    newSuffix = newSuffix.substring(0, 15);
                }
                this.suffix = newSuffix;
            }
        }
        this.currentValue = legacyValue;
        if (!this.player.equals(prevPlayer)) {
            this.oldPlayer = prevPlayer;
        }
    }

    @Override
    public void updateTeam() {
        Set<Player> players = this.handler.players();
        if (this.oldPlayer != null) {
            ObjectivePacketAdapter pd = this.handler.localeLineHandler().sidebar().packetAdapter();
            this.packetAdapter.sendEntries(EntriesPacketType.REMOVE, players, Collections.singleton(this.oldPlayer));
            pd.removeScore(players, this.oldPlayer);
            this.oldPlayer = null;
            this.packetAdapter.sendEntries(EntriesPacketType.ADD, players, Collections.singleton(this.player));
            pd.sendScore(players, this.player, this.info.objectiveScore(), null, null);
        }
        this.packetAdapter.sendProperties(PropertiesPacketType.UPDATE, players);
    }

    @Override
    public void resetOldPlayer() {
        this.oldPlayer = null;
    }

    @Override
    public void sendScore(@NotNull Collection<Player> players) {
        ObjectivePacketAdapter pd = this.handler.localeLineHandler().sidebar().packetAdapter();
        if (this.oldPlayer != null) {
            pd.removeScore(players, this.oldPlayer);
        }
        pd.sendScore(players, this.player, this.info.objectiveScore(), null, null);
    }

    @Override
    public void show(@NotNull Collection<Player> players) {
        this.sendScore(players);
        this.packetAdapter.sendProperties(PropertiesPacketType.CREATE, players);
    }

    @Override
    public void hide(@NotNull Collection<Player> players) {
        ObjectivePacketAdapter pd = this.handler.localeLineHandler().sidebar().packetAdapter();
        if (this.oldPlayer != null) {
            pd.removeScore(players, this.oldPlayer);
        }
        pd.removeScore(players, this.player);
        this.info.packetAdapter().removeTeam(players);
    }
}

