/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

import com.sun.jna.Platform;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.win32.Netapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsComputer;
import waffle.windows.auth.IWindowsDomain;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WaffleInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaffleInfo.class);

    public Document getWaffleInfo() throws ParserConfigurationException {
        DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
        df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        df.setExpandEntityReferences(false);
        Document doc = df.newDocumentBuilder().newDocument();
        Element root = doc.createElement("waffle");
        String version = WaffleInfo.class.getPackage().getImplementationVersion();
        if (version != null) {
            root.setAttribute("version", version);
        }
        if ((version = Platform.class.getPackage().getImplementationVersion()) != null) {
            root.setAttribute("jna", version);
        }
        if ((version = WindowUtils.class.getPackage().getImplementationVersion()) != null) {
            root.setAttribute("jna-platform", version);
        }
        doc.appendChild(root);
        root.appendChild(this.getAuthProviderInfo(doc));
        return doc;
    }

    protected Element getAuthProviderInfo(Document doc) {
        WindowsAuthProviderImpl auth = new WindowsAuthProviderImpl();
        Element node = doc.createElement("auth");
        node.setAttribute("class", auth.getClass().getName());
        Element child = doc.createElement("currentUser");
        node.appendChild(child);
        String currentUsername = WindowsAccountImpl.getCurrentUsername();
        this.addAccountInfo(doc, child, new WindowsAccountImpl(currentUsername));
        child = doc.createElement("computer");
        node.appendChild(child);
        IWindowsComputer c = auth.getCurrentComputer();
        Element value = doc.createElement("computerName");
        value.setTextContent(c.getComputerName());
        child.appendChild(value);
        value = doc.createElement("memberOf");
        value.setTextContent(c.getMemberOf());
        child.appendChild(value);
        value = doc.createElement("joinStatus");
        value.setTextContent(c.getJoinStatus());
        child.appendChild(value);
        value = doc.createElement("groups");
        for (String s2 : c.getGroups()) {
            Element g2 = doc.createElement("group");
            g2.setTextContent(s2);
            value.appendChild(g2);
        }
        child.appendChild(value);
        if (Netapi32Util.getJoinStatus() == 3) {
            child = doc.createElement("domains");
            node.appendChild(child);
            for (IWindowsDomain domain : auth.getDomains()) {
                Element d = doc.createElement("domain");
                node.appendChild(d);
                value = doc.createElement("FQN");
                value.setTextContent(domain.getFqn());
                child.appendChild(value);
                value = doc.createElement("TrustTypeString");
                value.setTextContent(domain.getTrustTypeString());
                child.appendChild(value);
                value = doc.createElement("TrustDirectionString");
                value.setTextContent(domain.getTrustDirectionString());
                child.appendChild(value);
            }
        }
        return node;
    }

    protected void addAccountInfo(Document doc, Element node, IWindowsAccount account) {
        Element value = doc.createElement("Name");
        value.setTextContent(account.getName());
        node.appendChild(value);
        value = doc.createElement("FQN");
        value.setTextContent(account.getFqn());
        node.appendChild(value);
        value = doc.createElement("Domain");
        value.setTextContent(account.getDomain());
        node.appendChild(value);
        value = doc.createElement("SID");
        value.setTextContent(account.getSidString());
        node.appendChild(value);
    }

    public Element getLookupInfo(Document doc, String lookup) {
        WindowsAuthProviderImpl auth = new WindowsAuthProviderImpl();
        Element node = doc.createElement("lookup");
        node.setAttribute("name", lookup);
        try {
            this.addAccountInfo(doc, node, auth.lookupAccount(lookup));
        }
        catch (Win32Exception e) {
            node.appendChild(WaffleInfo.getException(doc, e));
        }
        return node;
    }

    public static Element getException(Document doc, Exception t) {
        Element node = doc.createElement("exception");
        node.setAttribute("class", t.getClass().getName());
        Element value = doc.createElement("message");
        if (t.getMessage() != null) {
            value.setTextContent(t.getMessage());
            node.appendChild(value);
        }
        value = doc.createElement("trace");
        value.setTextContent(Arrays.toString(t.getStackTrace()));
        node.appendChild(value);
        return node;
    }

    public static String toPrettyXML(Document doc) throws TransformerException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        return sw.toString();
    }

    public static void main(String[] args) {
        boolean show = false;
        ArrayList<String> lookup = new ArrayList<String>();
        if (args != null) {
            block10: for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (null == arg) continue;
                switch (arg) {
                    case "-show": {
                        show = true;
                        continue block10;
                    }
                    case "-lookup": {
                        lookup.add(args[++i]);
                        continue block10;
                    }
                    default: {
                        LOGGER.error("Unknown Argument: {}", (Object)arg);
                        throw new RuntimeException("Unknown Argument: " + arg);
                    }
                }
            }
        }
        WaffleInfo helper = new WaffleInfo();
        try {
            Document info = helper.getWaffleInfo();
            for (String name : lookup) {
                info.getDocumentElement().appendChild(helper.getLookupInfo(info, name));
            }
            String xml = WaffleInfo.toPrettyXML(info);
            if (show) {
                File f = Files.createTempFile("waffle-info-", ".xml", new FileAttribute[0]).toFile();
                Files.write(f.toPath(), xml.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                Desktop.getDesktop().open(f);
            } else {
                LOGGER.info(xml);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            LOGGER.error(e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

