/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.context;

import io.github.xiewuzhiying.vs_addition.util.ConversionUtilsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J+\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lio/github/xiewuzhiying/vs_addition/context/ExtendedEntityDragger;", "", "<init>", "()V", "", "Lnet/minecraft/world/entity/Entity;", "entities", "", "dragEntitiesWithShips", "(Ljava/lang/Iterable;)V", "entity", "doDragEntityWithShip", "(Lnet/minecraft/world/entity/Entity;)V", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lkotlin/Pair;", "", "defaultDragger", "(Lnet/minecraft/world/entity/Entity;Lorg/valkyrienskies/core/api/ships/Ship;)Lkotlin/Pair;", "projectileDragger", "ADDED_MOVEMENT_DECAY", "D", "vs_addition_continue"})
@SourceDebugExtension(value={"SMAP\nExtendedEntityDragger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtendedEntityDragger.kt\nio/github/xiewuzhiying/vs_addition/context/ExtendedEntityDragger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1863#2,2:193\n*S KotlinDebug\n*F\n+ 1 ExtendedEntityDragger.kt\nio/github/xiewuzhiying/vs_addition/context/ExtendedEntityDragger\n*L\n28#1:193,2\n*E\n"})
public final class ExtendedEntityDragger {
    @NotNull
    public static final ExtendedEntityDragger INSTANCE = new ExtendedEntityDragger();
    private static final double ADDED_MOVEMENT_DECAY = 0.9;

    private ExtendedEntityDragger() {
    }

    @JvmStatic
    public static final void dragEntitiesWithShips(@NotNull Iterable<? extends Entity> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Iterable<? extends Entity> $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        Iterator<? extends Entity> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Entity element$iv;
            Entity entity = element$iv = iterator.next();
            boolean bl = false;
            ExtendedEntityDragger.doDragEntityWithShip(entity);
        }
    }

    @JvmStatic
    public static final void doDragEntityWithShip(@NotNull Entity entity) {
        double shipData2;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        EntityDraggingInformation entityDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
        boolean dragTheEntity = false;
        Vector3dc addedMovement = null;
        double addedXRot = 0.0;
        double addedYRot = 0.0;
        Long shipDraggingEntity = entityDraggingInformation.getLastShipStoodOn();
        if (shipDraggingEntity != null && entity.m_20202_() == null) {
            if (entityDraggingInformation.isEntityBeingDraggedByAShip()) {
                Ship shipData2 = VSGameUtilsKt.getShipObjectWorld((Level)entity.m_9236_()).getAllShips().getById(shipDraggingEntity.longValue());
                if (shipData2 != null) {
                    dragTheEntity = true;
                    Vector3d newPosIdeal = shipData2.getShipToWorld().transformPosition(shipData2.getPrevTickTransform().getWorldToShip().transformPosition(new Vector3d(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())));
                    addedMovement = (Vector3dc)new Vector3d(newPosIdeal.x - entity.m_20185_(), newPosIdeal.y - entity.m_20186_(), newPosIdeal.z - entity.m_20189_());
                    Pair<Double, Double> pair = entity instanceof Projectile ? ExtendedEntityDragger.projectileDragger(entity, shipData2) : INSTANCE.defaultDragger(entity, shipData2);
                    addedXRot = ((Number)pair.getFirst()).doubleValue();
                    addedYRot = ((Number)pair.getSecond()).doubleValue();
                }
            } else {
                dragTheEntity = true;
                addedMovement = (Vector3dc)entityDraggingInformation.getAddedMovementLastTick().mul(0.9, new Vector3d());
                addedXRot = ConversionUtilsKt.getAddedPitchRotLastTick(entityDraggingInformation) * 0.9;
                addedYRot = entityDraggingInformation.getAddedYawRotLastTick() * 0.9;
            }
        }
        if (dragTheEntity && addedMovement != null && addedMovement.isFinite() && !Double.isInfinite(shipData2 = addedYRot) && !Double.isNaN(shipData2) && !Double.isInfinite(shipData2 = addedXRot) && !Double.isNaN(shipData2)) {
            AABB newBB = entity.m_20191_().m_82383_(VectorConversionsMCKt.toMinecraft((Vector3dc)addedMovement));
            entity.m_20011_(newBB);
            entity.m_6034_(entity.m_20185_() + addedMovement.x(), entity.m_20186_() + addedMovement.y(), entity.m_20189_() + addedMovement.z());
            entityDraggingInformation.setAddedMovementLastTick(addedMovement);
            double d = addedYRot;
            if (!Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = addedXRot) && !Double.isNaN(d) && !(entity instanceof ServerPlayer)) {
                entity.m_146922_(entity.m_146908_() + (float)addedYRot);
                entity.m_5616_(entity.m_6080_() + (float)addedYRot);
                entity.m_146926_(entity.m_146909_() + (float)addedXRot);
                entityDraggingInformation.setAddedYawRotLastTick(addedYRot);
                ConversionUtilsKt.setAddedPitchRotLastTick(entityDraggingInformation, addedXRot);
            }
        }
        int n = entityDraggingInformation.getTicksSinceStoodOnShip();
        entityDraggingInformation.setTicksSinceStoodOnShip(n + 1);
        entityDraggingInformation.setMountedToEntity(entity.m_20202_() != null);
    }

    private final Pair<Double, Double> defaultDragger(Entity entity, Ship ship) {
        double newYRotAsDegrees;
        double addedYRotFromDragging;
        double yViewRot = entity.m_5675_(1.0f);
        Vector3d entityLookYawOnly = new Vector3d(Math.sin(-Math.toRadians(yViewRot)), 0.0, Math.cos(-Math.toRadians(yViewRot)));
        Vector3d newLookIdeal = ship.getShipToWorld().transformDirection(ship.getPrevTickTransform().getWorldToShip().transformDirection(entityLookYawOnly));
        double newXRot = Math.asin(-newLookIdeal.y());
        double xRotCos = Math.cos(newXRot);
        double newYRot = -Math.atan2(newLookIdeal.x() / xRotCos, newLookIdeal.z() / xRotCos);
        double entityYRotCorrected = (double)entity.m_146908_() % 360.0;
        if (entityYRotCorrected < -180.0) {
            entityYRotCorrected += 360.0;
        }
        if (entityYRotCorrected > 180.0) {
            entityYRotCorrected -= 360.0;
        }
        if ((addedYRotFromDragging = (newYRotAsDegrees = Math.toDegrees(newYRot)) - entityYRotCorrected) < -180.0) {
            addedYRotFromDragging += 360.0;
        }
        if (addedYRotFromDragging > 180.0) {
            addedYRotFromDragging -= 360.0;
        }
        return new Pair((Object)0.0, (Object)addedYRotFromDragging);
    }

    @JvmStatic
    private static final Pair<Double, Double> projectileDragger(Entity entity, Ship ship) {
        double entityXRotCorrected;
        Vec3 vec3 = entity.m_20252_(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getViewVector(...)");
        Vector3d entityLook = VectorConversionsMCKt.toJOML((Vec3)vec3);
        entityLook.x = -entityLook.x;
        entityLook.y = -entityLook.y;
        Vector3d newLookIdeal = ship.getShipToWorld().transformDirection(ship.getPrevTickTransform().getWorldToShip().transformDirection(entityLook));
        newLookIdeal.x = -newLookIdeal.x;
        newLookIdeal.y = -newLookIdeal.y;
        double newXRot = Math.asin(-newLookIdeal.y());
        double xRotCos = Math.cos(newXRot);
        double newYRot = -Math.atan2(newLookIdeal.x() / xRotCos, newLookIdeal.z() / xRotCos);
        double entityYRotCorrected = (double)entity.m_146908_() % 360.0;
        if (entityYRotCorrected < -180.0) {
            entityYRotCorrected += 360.0;
        }
        if (entityYRotCorrected > 180.0) {
            entityYRotCorrected -= 360.0;
        }
        if ((entityXRotCorrected = (double)entity.m_146909_() % 360.0) < -180.0) {
            entityXRotCorrected += 360.0;
        }
        if (entityXRotCorrected > 180.0) {
            entityXRotCorrected -= 360.0;
        }
        double newYRotAsDegrees = Math.toDegrees(newYRot);
        double newXRotAsDegrees = Math.toDegrees(newXRot);
        double addedYRotFromDragging = newYRotAsDegrees - entityYRotCorrected;
        double addedXRotFromDragging = newXRotAsDegrees - entityXRotCorrected;
        if (addedYRotFromDragging < -180.0) {
            addedYRotFromDragging += 360.0;
        }
        if (addedYRotFromDragging > 180.0) {
            addedYRotFromDragging -= 360.0;
        }
        if (addedXRotFromDragging < -180.0) {
            addedXRotFromDragging += 360.0;
        }
        if (addedXRotFromDragging > 180.0) {
            addedXRotFromDragging -= 360.0;
        }
        return new Pair((Object)addedXRotFromDragging, (Object)addedYRotFromDragging);
    }
}

