/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.forge.mixin.tacz;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.tacz.guns.util.block.ProjectileExplosion;
import io.github.xiewuzhiying.vs_addition.util.ShipUtilsKt;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ProjectileExplosion.class})
public abstract class MixinProjectileExplosion {
    @Mutable
    @Shadow(remap=false)
    @Final
    private double x;
    @Mutable
    @Shadow(remap=false)
    @Final
    private double y;
    @Mutable
    @Shadow(remap=false)
    @Final
    private double z;
    @Shadow(remap=false)
    @Final
    private float radius;
    @Shadow(remap=false)
    @Final
    private Level level;
    @Unique
    private boolean noRayTrace = false;

    @WrapMethod(method={"explode()V"})
    private void explode(Operation<Void> original) {
        ShipUtilsKt.explosionWrapper(this.level, (Function0<Unit>)((Function0)() -> {
            original.call(new Object[0]);
            return null;
        }), (Function0<? extends Vector3d>)((Function0)this::getOriginalPos), (Function1<? super Vector3dc, Unit>)((Function1)vector3dc -> {
            this.setPos((Vector3dc)vector3dc);
            return null;
        }), this.radius, (Function1<? super Boolean, Unit>)((Function1)bl -> {
            this.setNoRayTrace((boolean)bl);
            return null;
        }), (Function3<? super Level, ? super Vector3dc, ? super Double, Unit>)((Function3)(level, pos, radius) -> {
            ShipUtilsKt.doExplodeForce(level, pos, radius);
            return null;
        }));
    }

    @WrapOperation(method={"explode()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private List<Entity> noRayTrace(Level instance, Entity entity, AABB aabb, Operation<List<Entity>> getEntities) {
        if (this.noRayTrace) {
            return Collections.emptyList();
        }
        return (List)getEntities.call(new Object[]{instance, entity, aabb});
    }

    @Unique
    private Vector3d getOriginalPos() {
        return new Vector3d(this.x, this.y, this.z);
    }

    @Unique
    private void setPos(Vector3dc vector) {
        this.x = vector.x();
        this.y = vector.y();
        this.z = vector.z();
    }

    @Unique
    private void setNoRayTrace(boolean bl) {
        this.noRayTrace = bl;
    }
}

