/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.computercraft;

import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import io.github.xiewuzhiying.vs_addition.util.ConversionUtilsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Pseudo
@Mixin(value={TurtleBrain.class})
public abstract class MixinTurtleBrain {
    @Shadow(remap=false)
    public abstract TurtleBlockEntity getOwner();

    @Shadow(remap=false)
    public abstract void setOwner(TurtleBlockEntity var1);

    @Shadow
    public abstract Level getLevel();

    @ModifyVariable(method={"teleportTo(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z"}, at=@At(value="HEAD"), index=2, argsOnly=true)
    private BlockPos ValkyrienSkies2$teleportToBlockPos(BlockPos pos) {
        TurtleBlockEntity currentOwner = this.getOwner();
        BlockPos oldPos = currentOwner.getAccess().getPosition();
        Level world = this.getLevel();
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)world, (BlockPos)oldPos);
        if (ship != null) {
            Direction d = MixinTurtleBrain.getNewDirection(ship, currentOwner.getDirection());
            if (!MixinTurtleBrain.doesShipContainPoint(ship, pos)) {
                currentOwner.setDirection(d);
                this.setOwner(currentOwner);
                if (!MixinTurtleBrain.isShipScaled(ship)) {
                    return MixinTurtleBrain.getWorldPosFromShipPos(ship, pos);
                }
                if (MixinTurtleBrain.turtlesLeaveScaledShips()) {
                    return MixinTurtleBrain.getWorldPosFromShipPos(ship, pos);
                }
            }
        }
        return pos;
    }

    @Unique
    private static Direction getNewDirection(Ship ship, Direction direction) {
        Matrix4dc matrix = ship.getShipToWorld();
        Vec3i turtleDirectionVector = direction.m_122436_();
        Vector3d directionVec = matrix.transformDirection((double)turtleDirectionVector.m_123341_(), (double)turtleDirectionVector.m_123342_(), (double)turtleDirectionVector.m_123343_(), new Vector3d());
        Direction dir = Direction.m_122366_((double)directionVec.x, (double)directionVec.y, (double)directionVec.z);
        return dir;
    }

    @Unique
    private static boolean turtlesLeaveScaledShips() {
        return VSGameConfig.SERVER.getComputerCraft().getCanTurtlesLeaveScaledShips();
    }

    @Unique
    private static boolean isShipScaled(Ship ship) {
        Vector3d normalScale;
        Vector3dc scale = ship.getTransform().getShipToWorldScaling();
        return !scale.equals(normalScale = new Vector3d(1.0, 1.0, 1.0));
    }

    @Unique
    private static boolean doesShipContainPoint(Ship ship, BlockPos pos) {
        AABBic shipAABB = ship.getShipAABB();
        AABB t = new AABB((double)shipAABB.maxX(), (double)shipAABB.maxY(), (double)shipAABB.maxZ(), (double)shipAABB.minX(), (double)shipAABB.minY(), (double)shipAABB.minZ());
        return t.m_82381_(new AABB(pos));
    }

    @Unique
    private static BlockPos getWorldPosFromShipPos(Ship ship, BlockPos pos) {
        Vec3 tPos = VectorConversionsMCKt.toMinecraft((Vector3dc)VSGameUtilsKt.toWorldCoordinates((Ship)ship, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5)));
        BlockPos newPos = new BlockPos((Vec3i)ConversionUtilsKt.getToBlockPos(tPos));
        return newPos;
    }
}

