/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.computercraft;

import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.TurtleMoveCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Pseudo
@Mixin(value={TurtleMoveCommand.class})
public abstract class MixinTurtleMoveCommand {
    @Inject(method={"canEnter"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    private static void ValkyrienSkies2$canEnter(TurtlePlayer turtlePlayer, ServerLevel world, BlockPos position, CallbackInfoReturnable<TurtleCommandResult> cir) {
        if (((TurtleCommandResult)cir.getReturnValue()).isSuccess()) {
            ServerShip ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)world, (BlockPos)position);
            if (ship == null) {
                ServerShip iShip = VSGameUtilsKt.getShipManagingPos((ServerLevel)world, (Vector3dc)MixinTurtleMoveCommand.getShipPosFromWorldPos((Level)world, position));
                if (iShip != null) {
                    cir.setReturnValue((Object)TurtleCommandResult.failure((String)"ship"));
                }
            } else {
                ChunkPos chunk = world.m_46745_(position).m_7697_();
                if (!ship.getChunkClaim().contains(chunk.f_45578_, chunk.f_45579_)) {
                    cir.setReturnValue((Object)TurtleCommandResult.failure((String)"out of ship"));
                }
            }
        }
    }

    @Unique
    private static Vector3d getShipPosFromWorldPos(Level world, BlockPos position) {
        List detectedShips = VSGameUtilsKt.transformToNearbyShipsAndWorld((Level)world, (double)((double)position.m_123341_() + 0.5), (double)((double)position.m_123342_() + 0.5), (double)((double)position.m_123343_() + 0.5), (double)0.1);
        for (Vector3d vec : detectedShips) {
            if (vec == null) continue;
            return vec;
        }
        return new Vector3d((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
    }
}

