/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.xiewuzhiying.vs_addition.context.conditiontester.ExplosionConditionTester;
import io.github.xiewuzhiying.vs_addition.util.ConversionUtilsKt;
import io.github.xiewuzhiying.vs_addition.util.ShipUtilsKt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.util.AABBdUtilKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.util.GameTickForceApplier;

@Restriction(require={@Condition(type=Condition.Type.TESTER, tester=ExplosionConditionTester.class)})
@Pseudo
@Mixin(value={Explosion.class})
public abstract class MixinExplosion {
    @Mutable
    @Shadow
    @Final
    private double f_46013_;
    @Shadow
    @Final
    private Level f_46012_;
    @Mutable
    @Shadow
    @Final
    private double f_46014_;
    @Mutable
    @Shadow
    @Final
    private double f_46015_;
    @Shadow
    public float f_46017_;
    @Shadow
    @Final
    private ExplosionDamageCalculator f_46019_;

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;)V"}, at={@At(value="TAIL")})
    private void toWorld(Level level, Entity source, DamageSource damageSource, ExplosionDamageCalculator damageCalculator, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, CallbackInfo ci) {
        Vector3d vector3d = VSGameUtilsKt.toWorldCoordinates((Level)this.f_46012_, (Vector3d)new Vector3d(this.f_46013_, this.f_46014_, this.f_46015_));
        this.f_46013_ = vector3d.x;
        this.f_46014_ = vector3d.y;
        this.f_46015_ = vector3d.z;
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")})
    private void getShips(CallbackInfo ci, @Share(value="pairs") LocalRef<Iterable<ImmutablePair<LoadedShip, GameTickForceApplier>>> pairs) {
        ArrayList<ImmutablePair> list = new ArrayList<ImmutablePair>();
        Iterable<LoadedShip> ships = ShipUtilsKt.getLoadedShipsIntersecting(this.f_46012_, (AABBdc)AABBdUtilKt.expand((AABBd)new AABBd(this.f_46013_, this.f_46014_, this.f_46015_, this.f_46013_, this.f_46014_, this.f_46015_), (double)this.f_46017_));
        for (LoadedShip ship : ships) {
            if (this.f_46012_.m_5776_()) {
                list.add(ImmutablePair.of((Object)ship, null));
                continue;
            }
            if (!(ship instanceof LoadedServerShip)) continue;
            LoadedServerShip serverShip = (LoadedServerShip)ship;
            GameTickForceApplier applier = (GameTickForceApplier)serverShip.getAttachment(GameTickForceApplier.class);
            if (applier == null) {
                applier = new GameTickForceApplier();
                serverShip.setAttachment(GameTickForceApplier.class, (Object)applier);
            }
            list.add(ImmutablePair.of((Object)serverShip, (Object)applier));
        }
        pairs.set(Collections.unmodifiableList(list));
    }

    @ModifyExpressionValue(method={"explode"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isInWorldBounds(Lnet/minecraft/core/BlockPos;)Z")})
    private boolean injector(boolean original, @Local(ordinal=4) double m, @Local(ordinal=5) double n, @Local(ordinal=6) double o, @Local(ordinal=0) LocalFloatRef h, @Local Set<BlockPos> set, @Share(value="pairs") LocalRef<Iterable<ImmutablePair<LoadedShip, GameTickForceApplier>>> pairs) {
        boolean needToBreak = false;
        for (ImmutablePair pair : (Iterable)pairs.get()) {
            FluidState fluidState;
            BlockState blockState;
            if (!(h.get() > 0.0f)) {
                needToBreak = true;
                break;
            }
            Matrix4dc worldToShip = ((LoadedShip)pair.getLeft()).getTransform().getWorldToShip();
            Vector3d vec31 = worldToShip.transformPosition(new Vector3d(m, n, o));
            BlockPos blockPos = ConversionUtilsKt.getToBlockPos((Vector3dc)vec31);
            Optional optional = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, blockPos, blockState = this.f_46012_.m_8055_(blockPos), fluidState = this.f_46012_.m_6425_(blockPos));
            if (optional.isPresent()) {
                GameTickForceApplier forceApplier;
                float originH = h.get();
                float sub = (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                if (!this.f_46012_.m_5776_() && (forceApplier = (GameTickForceApplier)pair.getRight()) != null) {
                    Vector3d vec32 = worldToShip.transformPosition(new Vector3d(this.f_46013_, this.f_46014_, this.f_46015_));
                    vec32.sub((Vector3dc)vec31);
                    double distanceMult = Math.max(0.0, (double)this.f_46017_ - vec32.length());
                    vec32.normalize();
                    vec32.mul(distanceMult);
                    vec32.mul(VSGameConfig.SERVER.getExplosionBlastForce() * (double)Math.min(originH, sub) * 1.0E-6);
                    if (vec32.isFinite()) {
                        forceApplier.applyInvariantForceToPos((Vector3dc)vec32, (Vector3dc)vec31);
                    }
                }
                h.set(originH - sub);
            }
            if (!(h.get() > 0.0f) || !this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, blockPos, blockState, h.get())) continue;
            set.add(blockPos);
        }
        return original && !needToBreak;
    }
}

