/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.context.airpocket;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import io.github.xiewuzhiying.vs_addition.VSAdditionConfig;
import io.github.xiewuzhiying.vs_addition.networking.airpocket.SyncAllPocketsC2SPacket;
import io.github.xiewuzhiying.vs_addition.util.ShipUtilsKt;
import io.github.xiewuzhiying.vs_addition.util.math.MathUtilsKt;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.LineSegmentd;
import org.joml.primitives.Planed;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.collision.ConvexPolygonc;
import org.valkyrienskies.core.apigame.collision.EntityPolygonCollider;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClientWorld;
import org.valkyrienskies.mod.common.IShipObjectWorldClientProvider;
import org.valkyrienskies.mod.common.VSClientGameUtils;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\f\u001a\u00020\u000b2\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\n\u0010\b\u001a\u00060\u0004j\u0002`\u00072\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u0010\u001a\u00020\u000b2\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u0019\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u00152\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJA\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u00152\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0003\u00a2\u0006\u0004\b\u001f\u0010 J)\u0010'\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010%H\u0007\u00a2\u0006\u0004\b'\u0010(JM\u00101\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020!2\u0006\u0010*\u001a\u00020)2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b1\u00102J5\u00107\u001a\u00020\u000b2\u0006\u00103\u001a\u00020.2\u0006\u00105\u001a\u0002042\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u00106\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b7\u00108J+\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u00109\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b:\u0010;J'\u0010<\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010%\u00a2\u0006\u0004\b<\u0010(J%\u0010B\u001a\u00020\u000b2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010A\u001a\u00020@H\u0007\u00a2\u0006\u0004\bB\u0010CJ\u001f\u0010G\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020DH\u0003\u00a2\u0006\u0004\bG\u0010HR,\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000e0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\bI\u0010J\u0012\u0004\bM\u0010\u0003\u001a\u0004\bK\u0010LR\u0018\u0010N\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0014\u0010Q\u001a\u00020P8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010RR\u0014\u0010T\u001a\u00020S8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bT\u0010UR\u0014\u0010V\u001a\u00020S8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bV\u0010UR\u001c\u0010W\u001a\u00020S8\u0002@\u0002X\u0083\u000e\u00a2\u0006\f\n\u0004\bW\u0010U\u0012\u0004\bX\u0010\u0003R\u001c\u0010Z\u001a\u00020Y8\u0002@\u0002X\u0083\u000e\u00a2\u0006\f\n\u0004\bZ\u0010[\u0012\u0004\b\\\u0010\u0003\u00a8\u0006]"}, d2={"Lio/github/xiewuzhiying/vs_addition/context/airpocket/FakeAirPocketClient;", "", "<init>", "()V", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "Lio/github/xiewuzhiying/vs_addition/context/airpocket/PocketId;", "pocketId", "Lorg/joml/primitives/AABBdc;", "aabb", "", "setAirPocket", "(JJLorg/joml/primitives/AABBdc;)V", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "pockets", "setAirPockets", "(JLit/unimi/dsi/fastutil/longs/Long2ObjectMap;)V", "Lorg/joml/Vector3dc;", "point", "checkRange", "", "checkIfPointInAirPocket", "(Lorg/joml/Vector3dc;Lorg/joml/primitives/AABBdc;)Z", "mustBeContained", "checkIfAABBInAirPocket", "(Lorg/joml/primitives/AABBdc;ZLorg/joml/primitives/AABBdc;)Z", "Lkotlin/Pair;", "checkIfPointAndAABBInAirPocket", "(Lorg/joml/Vector3dc;Lorg/joml/primitives/AABBdc;ZLorg/joml/primitives/AABBdc;)Lkotlin/Pair;", "Lorg/valkyrienskies/core/apigame/collision/EntityPolygonCollider;", "getCollider", "()Lorg/valkyrienskies/core/apigame/collision/EntityPolygonCollider;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/Camera;", "camera", "Lnet/minecraft/client/renderer/MultiBufferSource;", "bufferSource", "render", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/MultiBufferSource;)V", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "transform", "offset", "", "vertices", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "maskConsumer", "bl", "renderMask", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Ljava/util/List;Lcom/mojang/blaze3d/vertex/VertexConsumer;Z)V", "consumer", "Lorg/joml/Matrix4f;", "matrix", "order", "renderTriangle", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;Ljava/util/List;Z)V", "planeNormal", "sortVertices", "(Ljava/util/List;Lorg/joml/Vector3dc;)Ljava/util/List;", "renderHighLight", "Lcom/mojang/brigadier/CommandDispatcher;", "Ldev/architectury/event/events/client/ClientCommandRegistrationEvent$ClientCommandSourceStack;", "dispatcher", "Lnet/minecraft/commands/CommandBuildContext;", "context", "registerCommands", "(Lcom/mojang/brigadier/CommandDispatcher;Lnet/minecraft/commands/CommandBuildContext;)V", "", "title", "message", "debug", "(Ljava/lang/String;Ljava/lang/String;)V", "map", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "getMap", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "getMap$annotations", "collider", "Lorg/valkyrienskies/core/apigame/collision/EntityPolygonCollider;", "Lnet/minecraft/client/renderer/RenderType$CompositeRenderType;", "WATER_MASK", "Lnet/minecraft/client/renderer/RenderType$CompositeRenderType;", "", "WATER_OFFSET", "D", "ZFIGHT", "SEA_LEVEL", "getSEA_LEVEL$annotations", "", "timer", "I", "getTimer$annotations", "vs_addition_continue"})
@SourceDebugExtension(value={"SMAP\nFakeAirPocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeAirPocketClient.kt\nio/github/xiewuzhiying/vs_addition/context/airpocket/FakeAirPocketClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,444:1\n216#2,2:445\n216#2:447\n217#2:452\n216#2:453\n217#2:458\n216#2:460\n217#2:468\n216#2,2:474\n1863#3,2:448\n1863#3,2:450\n1863#3,2:454\n1863#3,2:456\n1863#3:459\n1863#3,2:461\n774#3:463\n865#3,2:464\n1863#3,2:466\n1864#3:469\n1863#3,2:470\n1053#3:472\n1863#3:473\n1864#3:476\n*S KotlinDebug\n*F\n+ 1 FakeAirPocketClient.kt\nio/github/xiewuzhiying/vs_addition/context/airpocket/FakeAirPocketClient\n*L\n70#1:445,2\n90#1:447\n90#1:452\n127#1:453\n127#1:458\n203#1:460\n203#1:468\n377#1:474,2\n93#1:448,2\n100#1:450,2\n136#1:454,2\n144#1:456,2\n201#1:459\n210#1:461,2\n218#1:463\n218#1:464,2\n219#1:466,2\n201#1:469\n355#1:470,2\n363#1:472\n375#1:473\n375#1:476\n*E\n"})
public final class FakeAirPocketClient {
    @NotNull
    public static final FakeAirPocketClient INSTANCE = new FakeAirPocketClient();
    @NotNull
    private static final Long2ObjectMap<Long2ObjectMap<AABBdc>> map = (Long2ObjectMap)new Long2ObjectOpenHashMap();
    @Nullable
    private static EntityPolygonCollider collider;
    @NotNull
    private static final RenderType.CompositeRenderType WATER_MASK;
    private static final double WATER_OFFSET = 0.8888888888888888;
    private static final double ZFIGHT = 0.002;
    private static double SEA_LEVEL;
    private static int timer;

    private FakeAirPocketClient() {
    }

    @NotNull
    public static final Long2ObjectMap<Long2ObjectMap<AABBdc>> getMap() {
        return map;
    }

    @JvmStatic
    public static /* synthetic */ void getMap$annotations() {
    }

    @JvmStatic
    public static final void setAirPocket(long shipId, long pocketId, @NotNull AABBdc aabb) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        map.computeIfAbsent(shipId, FakeAirPocketClient::setAirPocket$lambda$0);
    }

    @JvmStatic
    public static final void setAirPockets(long shipId, @NotNull Long2ObjectMap<AABBdc> pockets) {
        Intrinsics.checkNotNullParameter(pockets, (String)"pockets");
        Long l = shipId;
        ((Map)map).put(l, pockets);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean checkIfPointInAirPocket(@NotNull Vector3dc point, @Nullable AABBdc checkRange) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Level level2 = (Level)level;
        AABBdc aABBdc = checkRange;
        if (aABBdc == null) {
            aABBdc = (AABBdc)new AABBd(point, (Vector3dc)new Vector3d(point.x() + 1.0, point.y() + 1.0, point.z() + 1.0));
        }
        Iterable<LoadedShip> ships = ShipUtilsKt.getLoadedShipsIntersecting(level2, aABBdc);
        for (Ship ship : ships) {
            Long2ObjectMap pockets;
            long shipId = ship.getId();
            if ((Long2ObjectMap)map.get(shipId) == null) continue;
            Map $this$forEach$iv = (Map)pockets;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                AABBdc pocket = (AABBdc)entry.getValue();
                if (!pocket.containsPoint((Vector3dc)ship.getWorldToShip().transformPosition(point, new Vector3d()))) continue;
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean checkIfPointInAirPocket$default(Vector3dc vector3dc, AABBdc aABBdc, int n, Object object) {
        if ((n & 2) != 0) {
            aABBdc = null;
        }
        return FakeAirPocketClient.checkIfPointInAirPocket(vector3dc, aABBdc);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean checkIfAABBInAirPocket(@NotNull AABBdc aabb, boolean mustBeContained, @Nullable AABBdc checkRange) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Level level2 = (Level)level;
        AABBdc aABBdc = checkRange;
        if (aABBdc == null) {
            aABBdc = aabb;
        }
        Iterable<LoadedShip> ships = ShipUtilsKt.getLoadedShipsIntersecting(level2, aABBdc);
        for (Ship ship : ships) {
            Long2ObjectMap pockets;
            long shipId = ship.getId();
            if ((Long2ObjectMap)map.get(shipId) == null) continue;
            ConvexPolygonc polygon = null;
            Map $this$forEach$iv = (Map)pockets;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                AABBdc pocket = (AABBdc)entry.getValue();
                if (polygon == null) {
                    polygon = FakeAirPocketClient.getCollider().createPolygonFromAABB(aabb, ship.getTransform().getWorldToShip(), Long.valueOf(ship.getId()));
                }
                if (!mustBeContained) {
                    ConvexPolygonc convexPolygonc = polygon;
                    Intrinsics.checkNotNull(convexPolygonc);
                    Iterable $this$forEach$iv2 = convexPolygonc.getPoints();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Vector3dc point = (Vector3dc)element$iv2;
                        boolean bl2 = false;
                        if (!pocket.containsPoint((Vector3dc)ship.getWorldToShip().transformPosition(point, new Vector3d()))) continue;
                        return true;
                    }
                    continue;
                }
                Object[] $i$f$forEach2 = new Boolean[]{false};
                List notContained = CollectionsKt.mutableListOf((Object[])$i$f$forEach2);
                ConvexPolygonc convexPolygonc = polygon;
                Intrinsics.checkNotNull((Object)convexPolygonc);
                Iterable $this$forEach$iv3 = convexPolygonc.getPoints();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Vector3dc point = (Vector3dc)element$iv3;
                    boolean bl3 = false;
                    if (pocket.containsPoint((Vector3dc)ship.getWorldToShip().transformPosition(point, new Vector3d()))) continue;
                    notContained.set(0, true);
                }
                if (((Boolean)notContained.get(0)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean checkIfAABBInAirPocket$default(AABBdc aABBdc, boolean bl, AABBdc aABBdc2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            aABBdc2 = null;
        }
        return FakeAirPocketClient.checkIfAABBInAirPocket(aABBdc, bl, aABBdc2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<Boolean, Boolean> checkIfPointAndAABBInAirPocket(@NotNull Vector3dc point, @NotNull AABBdc aabb, boolean mustBeContained, @Nullable AABBdc checkRange) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        boolean pointBl = false;
        boolean aabbBl = false;
        Level level2 = (Level)level;
        AABBdc aABBdc = checkRange;
        if (aABBdc == null) {
            aABBdc = aabb;
        }
        Iterable<LoadedShip> ships = ShipUtilsKt.getLoadedShipsIntersecting(level2, aABBdc);
        for (Ship ship : ships) {
            Long2ObjectMap pockets;
            long shipId = ship.getId();
            if ((Long2ObjectMap)map.get(shipId) == null) continue;
            ConvexPolygonc polygon = null;
            Map $this$forEach$iv = (Map)pockets;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                AABBdc pocket = (AABBdc)entry.getValue();
                if (!pointBl && pocket.containsPoint((Vector3dc)ship.getWorldToShip().transformPosition(point, new Vector3d()))) {
                    pointBl = true;
                }
                if (!aabbBl) {
                    if (!mustBeContained) {
                        if (polygon == null) {
                            polygon = FakeAirPocketClient.getCollider().createPolygonFromAABB(aabb, ship.getWorldToShip(), Long.valueOf(ship.getId()));
                        }
                        ConvexPolygonc convexPolygonc = polygon;
                        Intrinsics.checkNotNull(convexPolygonc);
                        Iterable $this$forEach$iv2 = convexPolygonc.getPoints();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            Vector3dc point2 = (Vector3dc)element$iv2;
                            boolean bl2 = false;
                            if (!pocket.containsPoint(point2)) continue;
                            aabbBl = true;
                        }
                    } else {
                        if (polygon == null) {
                            polygon = FakeAirPocketClient.getCollider().createPolygonFromAABB(aabb, ship.getWorldToShip(), Long.valueOf(ship.getId()));
                        }
                        Object[] $i$f$forEach2 = new Boolean[]{false};
                        List notContained = CollectionsKt.mutableListOf((Object[])$i$f$forEach2);
                        ConvexPolygonc convexPolygonc = polygon;
                        Intrinsics.checkNotNull((Object)convexPolygonc);
                        Iterable $this$forEach$iv3 = convexPolygonc.getPoints();
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            Vector3dc point2 = (Vector3dc)element$iv3;
                            boolean bl3 = false;
                            if (pocket.containsPoint(point2)) continue;
                            notContained.set(0, true);
                        }
                        boolean bl2 = aabbBl = (Boolean)notContained.get(0) == false;
                    }
                }
                if (!pointBl || !aabbBl) continue;
                return new Pair((Object)true, (Object)true);
            }
        }
        return new Pair((Object)pointBl, (Object)aabbBl);
    }

    public static /* synthetic */ Pair checkIfPointAndAABBInAirPocket$default(Vector3dc vector3dc, AABBdc aABBdc, boolean bl, AABBdc aABBdc2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            aABBdc2 = null;
        }
        return FakeAirPocketClient.checkIfPointAndAABBInAirPocket(vector3dc, aABBdc, bl, aABBdc2);
    }

    @JvmStatic
    private static final EntityPolygonCollider getCollider() {
        if (collider == null) {
            collider = ValkyrienSkiesMod.getVsCore().getEntityPolygonCollider();
        }
        EntityPolygonCollider entityPolygonCollider = collider;
        Intrinsics.checkNotNull((Object)entityPolygonCollider);
        return entityPolygonCollider;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void render(@NotNull PoseStack ms, @NotNull Camera camera, @Nullable MultiBufferSource bufferSource) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (!VSAdditionConfig.COMMON.getExperimental().getFakeAirPocket() || !VSAdditionConfig.CLIENT.getExperimental().getCullWaterSurfaceInFakeAirPocket()) {
            return;
        }
        MultiBufferSource multiBufferSource = bufferSource;
        if (multiBufferSource == null || (multiBufferSource = multiBufferSource.m_6299_((RenderType)WATER_MASK)) == null) {
            return;
        }
        MultiBufferSource waterMaskConsumer = multiBufferSource;
        Minecraft minecraft = Minecraft.m_91087_();
        IShipObjectWorldClientProvider iShipObjectWorldClientProvider = minecraft instanceof IShipObjectWorldClientProvider ? (IShipObjectWorldClientProvider)minecraft : null;
        ClientShipWorldCore clientShipWorldCore = iShipObjectWorldClientProvider != null ? iShipObjectWorldClientProvider.getShipObjectWorld() : null;
        ShipObjectClientWorld shipObjectClientWorld = clientShipWorldCore instanceof ShipObjectClientWorld ? (ShipObjectClientWorld)clientShipWorldCore : null;
        if (shipObjectClientWorld == null) {
            return;
        }
        ShipObjectClientWorld shipClientWorld = shipObjectClientWorld;
        Vec3 vec3 = camera.m_90583_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        Vector3d cameraPosition = VectorConversionsMCKt.toJOML((Vec3)vec3);
        QueryableShipData loadedShips = shipClientWorld.getLoadedShips();
        Set set = map.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            ShipObjectClient shipObjectClient = (ShipObjectClient)loadedShips.getById(((Number)k).longValue());
            if (shipObjectClient == null || (shipObjectClient = shipObjectClient.getRenderTransform()) == null) continue;
            ShipObjectClient transform = shipObjectClient;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            Map $this$forEach$iv2 = (Map)v;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$filterTo$iv$iv;
                Iterable element$iv22;
                Map.Entry element$iv3;
                Map.Entry entry2 = element$iv3 = iterator.next();
                boolean bl2 = false;
                Long pocketId = (Long)entry2.getKey();
                AABBdc aabb = (AABBdc)entry2.getValue();
                Intrinsics.checkNotNull((Object)aabb);
                AABBdc aabb2 = MathUtilsKt.moveToOrigin(aabb);
                Planed plane = new Planed((Vector3dc)transform.getWorldToShip().transformPosition(new Vector3d(0.0, SEA_LEVEL, 0.0)).sub((Vector3dc)aabb.center(new Vector3d())), (Vector3dc)transform.getWorldToShip().transformDirection(new Vector3d(0.0, 1.0, 0.0)));
                List mask = new ArrayList();
                if (MathUtilsKt.testPlane(aabb2, plane)) {
                    Iterable $this$forEach$iv3 = MathUtilsKt.toLineSegments(aabb2);
                    boolean $i$f$forEach3 = false;
                    for (Iterable element$iv22 : $this$forEach$iv3) {
                        LineSegmentd line = (LineSegmentd)element$iv22;
                        boolean bl3 = false;
                        Vector3d dest = new Vector3d();
                        if (!MathUtilsKt.intersect(line, plane, dest)) continue;
                        mask.add(dest);
                    }
                }
                Iterable $this$filter$iv = MathUtilsKt.toPoints(aabb2);
                boolean $i$f$filter = false;
                element$iv22 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Vector3dc it = (Vector3dc)element$iv$iv;
                    boolean bl4 = false;
                    if (!MathUtilsKt.isBehindPlane(it, plane)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List section = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                Iterable $this$forEach$iv4 = mask;
                boolean $i$f$forEach4 = false;
                for (Object element$iv4 : $this$forEach$iv4) {
                    Vector3dc it = (Vector3dc)element$iv4;
                    boolean bl5 = false;
                    section.add(it);
                }
                Vector3d cameraPosition2 = transform.getWorldToShip().transformPosition(new Vector3d((Vector3dc)cameraPosition)).sub((Vector3dc)aabb.center(new Vector3d()));
                Vector3dc vector3dc = (Vector3dc)cameraPosition;
                Vector3d vector3d = aabb.center(new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"center(...)");
                Vector3dc vector3dc2 = (Vector3dc)vector3d;
                List<Vector3dc> list = INSTANCE.sortVertices(mask, (Vector3dc)MathUtilsKt.getNormal(plane));
                Intrinsics.checkNotNull((Object)cameraPosition2);
                INSTANCE.renderMask(ms, (ShipTransform)transform, vector3dc, vector3dc2, list, (VertexConsumer)waterMaskConsumer, MathUtilsKt.isInFrontOfPlane((Vector3dc)cameraPosition2, plane));
            }
        }
    }

    private final void renderMask(PoseStack ms, ShipTransform transform, Vector3dc camera, Vector3dc offset, List<? extends Vector3dc> vertices, VertexConsumer maskConsumer, boolean bl) {
        if (vertices.size() < 3) {
            return;
        }
        ms.m_85836_();
        VSClientGameUtils.transformRenderWithShip((ShipTransform)transform, (PoseStack)ms, (double)offset.x(), (double)offset.y(), (double)offset.z(), (double)camera.x(), (double)(camera.y() + (bl ? 0.0 : 0.002)), (double)camera.z());
        Matrix4f matrix4f = ms.m_85850_().m_252922_();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
        this.renderTriangle(maskConsumer, matrix4f, vertices, bl);
        ms.m_85849_();
    }

    private final void renderTriangle(VertexConsumer consumer, Matrix4f matrix, List<? extends Vector3dc> vertices, boolean order) {
        int n = vertices.size() - 1;
        for (int i = 1; i < n; ++i) {
            Pair pair = order ? new Pair((Object)(i + 1), (Object)0) : new Pair((Object)0, (Object)(i + 1));
            int first = ((Number)pair.component1()).intValue();
            int n2 = ((Number)pair.component2()).intValue();
            consumer.m_252986_(matrix, (float)vertices.get(first).x(), (float)vertices.get(first).y(), (float)vertices.get(first).z()).m_5752_();
            consumer.m_252986_(matrix, (float)vertices.get(i).x(), (float)vertices.get(i).y(), (float)vertices.get(i).z()).m_5752_();
            consumer.m_252986_(matrix, (float)vertices.get(n2).x(), (float)vertices.get(n2).y(), (float)vertices.get(n2).z()).m_5752_();
        }
    }

    private final List<Vector3dc> sortVertices(List<? extends Vector3dc> vertices, Vector3dc planeNormal) {
        if (vertices.size() < 3) {
            return vertices;
        }
        Vector3d centroid = new Vector3d();
        Iterable $this$forEach$iv = vertices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vector3dc it = (Vector3dc)element$iv;
            boolean bl = false;
            centroid.add(it);
        }
        centroid.div((double)vertices.size());
        Vector3d $this$sortVertices_u24lambda_u2414 = $i$f$forEach = new Vector3d(1.0, 0.0, 0.0);
        boolean bl = false;
        if ($this$sortVertices_u24lambda_u2414.dot(planeNormal) > 0.999) {
            $this$sortVertices_u24lambda_u2414.set(0.0, 1.0, 0.0);
        }
        Vector3d right = $i$f$forEach.cross(planeNormal, new Vector3d()).normalize();
        Vector3d forward = new Vector3d((Vector3dc)right).cross(planeNormal).normalize();
        Iterable $this$sortedBy$iv = vertices;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(centroid, forward, right){
            final /* synthetic */ Vector3d $centroid$inlined;
            final /* synthetic */ Vector3d $forward$inlined;
            final /* synthetic */ Vector3d $right$inlined;
            {
                this.$centroid$inlined = vector3d;
                this.$forward$inlined = vector3d2;
                this.$right$inlined = vector3d3;
            }

            public final int compare(T a2, T b) {
                Vector3dc v = (Vector3dc)a2;
                boolean bl = false;
                Vector3d offset = new Vector3d(v).sub((Vector3dc)this.$centroid$inlined);
                v = (Vector3dc)b;
                Comparable comparable = Double.valueOf(Math.atan2(offset.dot((Vector3dc)this.$forward$inlined), offset.dot((Vector3dc)this.$right$inlined)));
                bl = false;
                offset = new Vector3d(v).sub((Vector3dc)this.$centroid$inlined);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(Math.atan2(offset.dot((Vector3dc)this.$forward$inlined), offset.dot((Vector3dc)this.$right$inlined))));
            }
        });
    }

    public final void renderHighLight(@NotNull PoseStack ms, @NotNull Camera camera, @Nullable MultiBufferSource bufferSource) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (!VSAdditionConfig.COMMON.getExperimental().getFakeAirPocket() || !VSAdditionConfig.CLIENT.getExperimental().getHighLightFakedAirPocket() || bufferSource == null) {
            return;
        }
        Vec3 cameraPosition = camera.m_90583_();
        Minecraft minecraft = Minecraft.m_91087_();
        Intrinsics.checkNotNull((Object)minecraft, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.common.IShipObjectWorldClientProvider");
        ClientShipWorldCore clientShipWorldCore = ((IShipObjectWorldClientProvider)minecraft).getShipObjectWorld();
        Intrinsics.checkNotNull((Object)clientShipWorldCore, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.ShipObjectClientWorld");
        ShipObjectClientWorld shipClientWorld = (ShipObjectClientWorld)clientShipWorldCore;
        QueryableShipData loadedShips = shipClientWorld.getLoadedShips();
        Set set = map.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            ShipObjectClient shipObjectClient = (ShipObjectClient)loadedShips.getById(((Number)k).longValue());
            if (shipObjectClient == null || (shipObjectClient = shipObjectClient.getRenderTransform()) == null) continue;
            ShipObjectClient transform = shipObjectClient;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            Map $this$forEach$iv2 = (Map)v;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry2 = element$iv2 = iterator.next();
                boolean bl2 = false;
                Long pocketId = (Long)entry2.getKey();
                AABBdc aabb = (AABBdc)entry2.getValue();
                Vector3d center = aabb.center(new Vector3d());
                AABB shipVoxelAABBAfterOffset = new AABB(aabb.minX() - center.x(), aabb.minY() - center.y(), aabb.minZ() - center.z(), aabb.maxX() - center.x(), aabb.maxY() - center.y(), aabb.maxZ() - center.z());
                ms.m_85836_();
                VSClientGameUtils.transformRenderWithShip((ShipTransform)transform, (PoseStack)ms, (double)center.x(), (double)center.y(), (double)center.z(), (double)cameraPosition.m_7096_(), (double)cameraPosition.m_7098_(), (double)cameraPosition.m_7094_());
                LevelRenderer.m_109646_((PoseStack)ms, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (AABB)shipVoxelAABBAfterOffset, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                ms.m_85849_();
            }
        }
    }

    @JvmStatic
    public static final void registerCommands(@NotNull CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher, @NotNull CommandBuildContext context) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"fresh-fake-air-pocket").requires(FakeAirPocketClient::registerCommands$lambda$18)).executes(FakeAirPocketClient::registerCommands$lambda$19));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)"get-ship-id-and-slug").requires(FakeAirPocketClient::registerCommands$lambda$20)).executes(FakeAirPocketClient::registerCommands$lambda$21));
    }

    @JvmStatic
    private static /* synthetic */ void getSEA_LEVEL$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void getTimer$annotations() {
    }

    @JvmStatic
    private static final void debug(String title, String message) {
        block2: {
            if (timer != 0) break block2;
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            if (clientLevel != null && (clientLevel = clientLevel.m_46473_()) != null) {
                clientLevel.m_6180_(title);
            }
            System.out.println((Object)message);
            ClientLevel clientLevel2 = Minecraft.m_91087_().f_91073_;
            if (clientLevel2 != null && (clientLevel2 = clientLevel2.m_46473_()) != null) {
                clientLevel2.m_7238_();
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean checkIfPointInAirPocket(@NotNull Vector3dc point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return FakeAirPocketClient.checkIfPointInAirPocket$default(point, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean checkIfAABBInAirPocket(@NotNull AABBdc aabb, boolean mustBeContained) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        return FakeAirPocketClient.checkIfAABBInAirPocket$default(aabb, mustBeContained, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean checkIfAABBInAirPocket(@NotNull AABBdc aabb) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        return FakeAirPocketClient.checkIfAABBInAirPocket$default(aabb, false, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<Boolean, Boolean> checkIfPointAndAABBInAirPocket(@NotNull Vector3dc point, @NotNull AABBdc aabb, boolean mustBeContained) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        return FakeAirPocketClient.checkIfPointAndAABBInAirPocket$default(point, aabb, mustBeContained, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<Boolean, Boolean> checkIfPointAndAABBInAirPocket(@NotNull Vector3dc point, @NotNull AABBdc aabb) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        return FakeAirPocketClient.checkIfPointAndAABBInAirPocket$default(point, aabb, false, null, 12, null);
    }

    private static final Long2ObjectOpenHashMap setAirPocket$lambda$0(long it) {
        return new Long2ObjectOpenHashMap();
    }

    private static final boolean registerCommands$lambda$18(ClientCommandRegistrationEvent.ClientCommandSourceStack source) {
        return source.m_6761_(1) && VSAdditionConfig.COMMON.getExperimental().getFakeAirPocket();
    }

    private static final int registerCommands$lambda$19(CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        LocalPlayer player = ((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource()).arch$getPlayer();
        HitResult ray = player.m_19907_(10.0, 1.0f, false);
        if (!(ray instanceof BlockHitResult)) {
            return 0;
        }
        ClientShip clientShip = VSClientGameUtils.getClientShip((double)((BlockHitResult)ray).m_82425_().m_123341_(), (double)((BlockHitResult)ray).m_82425_().m_123342_(), (double)((BlockHitResult)ray).m_82425_().m_123343_());
        if (clientShip == null) {
            return 0;
        }
        ClientShip ship = clientShip;
        new SyncAllPocketsC2SPacket(ship.getId()).sendToServer();
        return 1;
    }

    private static final boolean registerCommands$lambda$20(ClientCommandRegistrationEvent.ClientCommandSourceStack source) {
        return source.m_6761_(1);
    }

    private static final int registerCommands$lambda$21(CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        LocalPlayer player = ((ClientCommandRegistrationEvent.ClientCommandSourceStack)ctx.getSource()).arch$getPlayer();
        HitResult ray = player.m_19907_(10.0, 1.0f, false);
        if (!(ray instanceof BlockHitResult)) {
            return 0;
        }
        ClientShip clientShip = VSClientGameUtils.getClientShip((double)((BlockHitResult)ray).m_82425_().m_123341_(), (double)((BlockHitResult)ray).m_82425_().m_123342_(), (double)((BlockHitResult)ray).m_82425_().m_123343_());
        if (clientShip == null) {
            return 0;
        }
        ClientShip ship = clientShip;
        Object[] objectArray = new Object[]{ship.getId(), ship.getSlug()};
        player.m_213846_((Component)Component.m_237110_((String)"vs_addition.command.get_ship_id_and_slug", (Object[])objectArray));
        return 1;
    }

    static {
        RenderType.CompositeRenderType compositeRenderType = RenderType.m_173209_((String)"water_mask_triangles", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173076_).m_173290_(RenderStateShard.f_110147_).m_110687_(RenderStateShard.f_110116_).m_110691_(false));
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType, (String)"create(...)");
        WATER_MASK = compositeRenderType;
        SEA_LEVEL = VSAdditionConfig.CLIENT.getExperimental().getSeaLevel() + 0.8888888888888888;
    }
}

