/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.computercraft.client;

import dan200.computercraft.client.sound.SpeakerSound;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.client.audio.VelocityTickableSoundInstance;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Pseudo
@Mixin(value={SpeakerSound.class})
public abstract class MixinSpeakerSound
extends AbstractSoundInstance
implements VelocityTickableSoundInstance {
    @Unique
    private SpeakerPosition speakerPosition;
    @Unique
    private Ship ship;

    protected MixinSpeakerSound(ResourceLocation arg, SoundSource arg2, RandomSource arg3) {
        super(arg, arg2, arg3);
    }

    @Inject(method={"setPosition"}, at={@At(value="RETURN")}, remap=false)
    private void isOnShip(SpeakerPosition position, CallbackInfo ci) {
        this.speakerPosition = position;
        this.ship = VSGameUtilsKt.getShipManagingPos((Level)position.level(), (Position)position.position());
        if (this.ship != null) {
            Vec3 worldPos = VSGameUtilsKt.toWorldCoordinates((Level)this.speakerPosition.level(), (Vec3)this.speakerPosition.position());
            this.f_119575_ = worldPos.f_82479_;
            this.f_119576_ = worldPos.f_82480_;
            this.f_119577_ = worldPos.f_82481_;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void updateWorldPos(CallbackInfo ci) {
        if (this.ship != null) {
            Vec3 worldPos = VSGameUtilsKt.toWorldCoordinates((Level)this.speakerPosition.level(), (Vec3)this.speakerPosition.position());
            this.f_119575_ = worldPos.f_82479_;
            this.f_119576_ = worldPos.f_82480_;
            this.f_119577_ = worldPos.f_82481_;
        }
    }

    @NotNull
    public Vector3dc getVelocity() {
        return this.ship != null ? this.ship.getVelocity() : new Vector3d();
    }
}

