/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.create.contraptions.chassis.sticker;

import com.simibubi.create.content.contraptions.chassis.StickerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import io.github.xiewuzhiying.vs_addition.compats.create.content.contraptions.chassis.sticker.StickerConstraintManager;
import kotlin.jvm.functions.Function0;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Pseudo
@Mixin(value={StickerBlockEntity.class})
public abstract class MixinStickerBlockEntity
extends SmartBlockEntity {
    @Unique
    private boolean needUpdate = false;
    @Unique
    private boolean wasBlockStateExtended = false;
    @Unique
    private StickerConstraintManager manager = null;

    public MixinStickerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;tick()V", shift=At.Shift.AFTER)})
    public void stickerConstraints(CallbackInfo ci) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        boolean isExtended = this.isBlockStateExtended();
        StickerConstraintManager manager = this.getManager();
        if (manager != null) {
            if (isExtended) {
                manager.checkStickerConstraint();
            }
            if (isExtended != this.wasBlockStateExtended) {
                this.needUpdate = true;
                this.wasBlockStateExtended = isExtended;
            }
            if (this.needUpdate) {
                if (isExtended) {
                    manager.createStickerConstraint();
                } else {
                    manager.removeAllConstraintGroups();
                }
                this.needUpdate = false;
            }
        }
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void write(CompoundTag tag, boolean clientPacket, CallbackInfo ci) {
        StickerConstraintManager manager = this.getManager();
        if (manager != null) {
            manager.writeCompoundTag(tag);
        }
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    private void read(CompoundTag tag, boolean clientPacket, CallbackInfo ci) {
        StickerConstraintManager manager = this.getManager();
        if (manager != null) {
            manager.readCompoundTag(tag);
        }
    }

    public void remove() {
        StickerConstraintManager manager = this.getManager();
        if (manager != null) {
            manager.removeAllConstraintGroups();
        }
        super.remove();
    }

    @Unique
    private StickerConstraintManager getManager() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return null;
        }
        if (this.manager == null) {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            this.manager = new StickerConstraintManager(serverLevel, VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)this.f_58858_), this.f_58858_, (Function0<? extends Direction>)((Function0)this::getFacing), VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel));
        }
        return this.manager;
    }

    @Unique
    private Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
    }

    @Unique
    public boolean isAirOrFluid(BlockState state) {
        return state.m_60795_() || state.m_60819_() != Fluids.f_76191_.m_76145_();
    }

    @Shadow(remap=false)
    public abstract boolean isBlockStateExtended();
}

