/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiewuzhiying.vs_addition.mixin.minecraft;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Consumer;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Pseudo
@Mixin(value={AbstractArrow.class})
public abstract class MixinAbstractArrow
extends Entity
implements IEntityDraggingInformationProvider {
    public MixinAbstractArrow(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"shouldFall"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;noCollision(Lnet/minecraft/world/phys/AABB;)Z")})
    public boolean shipCollision(Level level, AABB aabb, Operation<Boolean> original) {
        boolean[] noShipCollision = new boolean[]{true};
        Consumer<AABB> consumer = aabb1 -> {
            if (noShipCollision[0]) {
                noShipCollision[0] = level.m_45772_(aabb1);
                Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.m_9236_(), (Position)aabb1.m_82399_());
                if (ship != null) {
                    this.getDraggingInformation().setLastShipStoodOn(Long.valueOf(ship.getId()));
                }
            }
        };
        VSGameUtilsKt.transformFromWorldToNearbyShipsAndWorld((Level)level, (AABB)aabb, consumer);
        return (Boolean)original.call(new Object[]{level, aabb}) != false && noShipCollision[0];
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void postInit(EntityType<? extends AbstractArrow> entityType, LivingEntity shooter, Level level, CallbackInfo ci) {
        LoadedShip ship = VSGameUtilsKt.getShipMountedTo((Entity)shooter);
        if (ship != null) {
            Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)shooter.m_20182_());
            ship.getTransform().getWorldToShip().transformPosition(pos);
            this.m_6034_(pos.x, pos.y + (double)shooter.m_20192_() - (double)0.1f, pos.z);
        }
    }
}

